/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReader {
    private static Logger logger = LoggerFactory.getLogger(ObjectReader.class);
    private FileInputStream fis = null;
    public ObjectInputStream ois = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(IObjectReader reader, String file) {
        Object obj = null;
        try {
            this.fis = new FileInputStream(file);
            this.ois = new ObjectInputStream(this.fis);
            obj = reader.readObject(this.ois);
        }
        catch (FileNotFoundException fnfex) {
        }
        catch (IOException ioex) {
            logger.error("Failed to read from {}", (Object)file);
        }
        catch (ClassNotFoundException cnfex) {
            logger.error("Failed to interpret content of {}", (Object)file);
        }
        catch (Exception e) {
        }
        finally {
            if (this.ois != null) {
                try {
                    this.ois.close();
                }
                catch (IOException ioex) {
                    logger.error("Failed to close object input stream: {}", (Object)file);
                }
            }
            if (this.fis != null) {
                try {
                    this.fis.close();
                }
                catch (IOException ioex) {
                    logger.error("Failed to close input file stream: {}", (Object)file);
                }
            }
        }
        return obj;
    }
}

