/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeConnectorCreator {
    protected static final Logger logger = LoggerFactory.getLogger(NodeConnectorCreator.class);

    public static NodeConnector createNodeConnector(Object portId, Node node) {
        if (node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            try {
                return new NodeConnector(NodeConnector.NodeConnectorIDType.OPENFLOW, portId, node);
            }
            catch (ConstructionException e1) {
                logger.error("", (Throwable)e1);
                return null;
            }
        }
        return null;
    }

    public static NodeConnector createNodeConnector(String portId, Node node) {
        return NodeConnector.fromString(String.format("%s|%s@%s", node.getType(), portId, node.toString()));
    }

    public static NodeConnector createNodeConnector(String nodeConnectorType, Object portId, Node node) {
        try {
            if (nodeConnectorType.equals(Node.NodeIDType.OPENFLOW) && portId.getClass() == String.class) {
                return new NodeConnector(nodeConnectorType, Short.parseShort((String)portId), node);
            }
            return new NodeConnector(nodeConnectorType, portId, node);
        }
        catch (ConstructionException e1) {
            logger.error("", (Throwable)e1);
            return null;
        }
    }

    public static NodeConnector createOFNodeConnector(Short portId, Node node) {
        try {
            return new NodeConnector(NodeConnector.NodeConnectorIDType.OPENFLOW, portId, node);
        }
        catch (ConstructionException e1) {
            logger.error("", (Throwable)e1);
            return null;
        }
    }

    public static Set<NodeConnector> createOFNodeConnectorSet(Set<Short> portIds, Node n) {
        try {
            HashSet<NodeConnector> nodeConnectors = new HashSet<NodeConnector>();
            for (Short ofPortID : portIds) {
                NodeConnector p = new NodeConnector(NodeConnector.NodeConnectorIDType.OPENFLOW, (short)ofPortID, n);
                nodeConnectors.add(p);
            }
            return nodeConnectors;
        }
        catch (ConstructionException e1) {
            logger.error("", (Throwable)e1);
            return null;
        }
    }
}

