/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiIterator<T>
implements Iterator<T> {
    Iterator<Iterator<T>> subIterator;
    Iterator<T> current = null;

    public MultiIterator(Iterator<Iterator<T>> subIterator) {
        this.subIterator = subIterator;
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            if (this.subIterator.hasNext()) {
                this.current = this.subIterator.next();
            } else {
                return false;
            }
        }
        while (!this.current.hasNext() && this.subIterator.hasNext()) {
            this.current = this.subIterator.next();
        }
        return this.current.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.current.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.hasNext()) {
            this.current.remove();
        }
        throw new NoSuchElementException();
    }
}

