/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opendaylight.controller.sal.utils.IListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerDispatcher<U, T extends IListener<U>> {
    protected static Logger logger = LoggerFactory.getLogger(ListenerDispatcher.class);
    volatile List<T> listeners = new ArrayList<T>();

    private void visit(List<T> newlisteners, U type, HashSet<T> visited, List<T> ordering, T listener) {
        if (!visited.contains(listener)) {
            visited.add(listener);
            for (IListener i : newlisteners) {
                if (!this.ispre(type, i, listener)) continue;
                this.visit(newlisteners, type, visited, ordering, i);
            }
            ordering.add(listener);
        }
    }

    private boolean ispre(U type, T l1, T l2) {
        return l2.isCallbackOrderingPrereq(type, l1.getName()) || l1.isCallbackOrderingPostreq(type, l2.getName());
    }

    public void addListener(U type, T listener) {
        ArrayList<T> newlisteners = new ArrayList<T>();
        if (this.listeners != null) {
            newlisteners.addAll(this.listeners);
        }
        newlisteners.add(listener);
        ArrayList<IListener> terminals = new ArrayList<IListener>();
        for (IListener i : newlisteners) {
            boolean isterm = true;
            for (IListener j : newlisteners) {
                if (!this.ispre(type, i, j)) continue;
                isterm = false;
                break;
            }
            if (!isterm) continue;
            terminals.add(i);
        }
        if (terminals.size() == 0) {
            logger.error("No listener dependency solution: No listeners without incoming dependencies");
            this.listeners = newlisteners;
            return;
        }
        HashSet visited = new HashSet();
        ArrayList<T> ordering = new ArrayList<T>();
        for (IListener term : terminals) {
            this.visit(newlisteners, type, visited, ordering, term);
        }
        this.listeners = ordering;
    }

    public void removeListener(T listener) {
        if (this.listeners != null) {
            ArrayList<T> newlisteners = new ArrayList<T>();
            newlisteners.addAll(this.listeners);
            newlisteners.remove(listener);
            this.listeners = newlisteners;
        }
    }

    public void clearListeners() {
        this.listeners = new ArrayList<T>();
    }

    public List<T> getOrderedListeners() {
        return this.listeners;
    }
}

