/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FilterIterator<T>
implements Iterator<T> {
    protected Iterator<T> subIterator;
    protected T next;

    public FilterIterator(Iterator<T> subIterator) {
        this.subIterator = subIterator;
    }

    protected abstract boolean matches(T var1);

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.subIterator.hasNext()) {
            this.next = this.subIterator.next();
            if (!this.matches(this.next)) continue;
            return true;
        }
        this.next = null;
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T cur = this.next;
            this.next = null;
            return cur;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

