/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.topology;

import java.util.Set;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;

public class TopoEdgeUpdate {
    private Edge edge;
    private Set<Property> props;
    private UpdateType type;
    private boolean isLocal;

    public TopoEdgeUpdate(Edge e, Set<Property> p, UpdateType t) {
        this.edge = e;
        this.props = p;
        this.type = t;
        this.setLocal(true);
    }

    public Edge getEdge() {
        return this.edge;
    }

    public Set<Property> getProperty() {
        return this.props;
    }

    public UpdateType getUpdateType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String toString() {
        return "TopoEdgeUpdate [edge=" + this.edge + ", props=" + this.props + ", type=" + (Object)((Object)this.type) + ", isLocal=" + this.isLocal + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopoEdgeUpdate other = (TopoEdgeUpdate)obj;
        if (this.edge == null ? other.edge != null : !this.edge.equals(other.edge)) {
            return false;
        }
        return this.type == other.type;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }
}

