/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.reader;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.NodeTable;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NodeTableStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private NodeTable nodeTable;
    @XmlElement
    private String name;
    @XmlElement
    private int activeCount;
    @XmlElement
    private long lookupCount;
    @XmlElement
    private long matchedCount;
    @XmlElement
    private int maximumEntries;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.activeCount;
        result = 31 * result + (int)(this.lookupCount ^ this.lookupCount >>> 32);
        result = 31 * result + (int)(this.matchedCount ^ this.matchedCount >>> 32);
        result = 31 * result + this.maximumEntries;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nodeTable == null ? 0 : this.nodeTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeTableStatistics)) {
            return false;
        }
        NodeTableStatistics other = (NodeTableStatistics)obj;
        if (this.activeCount != other.activeCount) {
            return false;
        }
        if (this.lookupCount != other.lookupCount) {
            return false;
        }
        if (this.matchedCount != other.matchedCount) {
            return false;
        }
        if (this.maximumEntries != other.maximumEntries) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.nodeTable == null ? other.nodeTable != null : !this.nodeTable.equals(other.nodeTable));
    }

    public NodeTable getNodeTable() {
        return this.nodeTable;
    }

    public void setNodeTable(NodeTable table) {
        this.nodeTable = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public long getLookupCount() {
        return this.lookupCount;
    }

    public void setLookupCount(long lookupCount) {
        this.lookupCount = lookupCount;
    }

    public long getMatchedCount() {
        return this.matchedCount;
    }

    public void setMatchedCount(long matchedCount) {
        this.matchedCount = matchedCount;
    }

    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    public void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    public String toString() {
        return "NodeTableStats[tableId = " + this.nodeTable + ", activeCount = " + this.activeCount + ", lookupCount = " + this.lookupCount + ", matchedCount = " + this.matchedCount + ", maximumEntries = " + this.maximumEntries + "]";
    }
}

