/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.reader;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.NodeConnector;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NodeConnectorStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private NodeConnector nodeConnector;
    @XmlElement
    private long receivePackets;
    @XmlElement
    private long transmitPackets;
    @XmlElement
    private long receiveBytes;
    @XmlElement
    private long transmitBytes;
    @XmlElement
    private long receiveDrops;
    @XmlElement
    private long transmitDrops;
    @XmlElement
    private long receiveErrors;
    @XmlElement
    private long transmitErrors;
    @XmlElement
    private long receiveFrameError;
    @XmlElement
    private long receiveOverRunError;
    @XmlElement
    private long receiveCrcError;
    @XmlElement
    private long collisionCount;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.collisionCount ^ this.collisionCount >>> 32);
        result = 31 * result + (this.nodeConnector == null ? 0 : this.nodeConnector.hashCode());
        result = 31 * result + (int)(this.receiveBytes ^ this.receiveBytes >>> 32);
        result = 31 * result + (int)(this.receiveCrcError ^ this.receiveCrcError >>> 32);
        result = 31 * result + (int)(this.receiveDrops ^ this.receiveDrops >>> 32);
        result = 31 * result + (int)(this.receiveErrors ^ this.receiveErrors >>> 32);
        result = 31 * result + (int)(this.receiveFrameError ^ this.receiveFrameError >>> 32);
        result = 31 * result + (int)(this.receiveOverRunError ^ this.receiveOverRunError >>> 32);
        result = 31 * result + (int)(this.receivePackets ^ this.receivePackets >>> 32);
        result = 31 * result + (int)(this.transmitBytes ^ this.transmitBytes >>> 32);
        result = 31 * result + (int)(this.transmitDrops ^ this.transmitDrops >>> 32);
        result = 31 * result + (int)(this.transmitErrors ^ this.transmitErrors >>> 32);
        result = 31 * result + (int)(this.transmitPackets ^ this.transmitPackets >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConnectorStatistics)) {
            return false;
        }
        NodeConnectorStatistics other = (NodeConnectorStatistics)obj;
        if (this.collisionCount != other.collisionCount) {
            return false;
        }
        if (this.nodeConnector == null ? other.nodeConnector != null : !this.nodeConnector.equals(other.nodeConnector)) {
            return false;
        }
        if (this.receiveBytes != other.receiveBytes) {
            return false;
        }
        if (this.receiveCrcError != other.receiveCrcError) {
            return false;
        }
        if (this.receiveDrops != other.receiveDrops) {
            return false;
        }
        if (this.receiveErrors != other.receiveErrors) {
            return false;
        }
        if (this.receiveFrameError != other.receiveFrameError) {
            return false;
        }
        if (this.receiveOverRunError != other.receiveOverRunError) {
            return false;
        }
        if (this.receivePackets != other.receivePackets) {
            return false;
        }
        if (this.transmitBytes != other.transmitBytes) {
            return false;
        }
        if (this.transmitDrops != other.transmitDrops) {
            return false;
        }
        if (this.transmitErrors != other.transmitErrors) {
            return false;
        }
        return this.transmitPackets == other.transmitPackets;
    }

    public void setNodeConnector(NodeConnector port) {
        this.nodeConnector = port;
    }

    public NodeConnector getNodeConnector() {
        return this.nodeConnector;
    }

    public void setReceivePacketCount(long count) {
        this.receivePackets = count;
    }

    public long getReceivePacketCount() {
        return this.receivePackets;
    }

    public void setTransmitPacketCount(long count) {
        this.transmitPackets = count;
    }

    public long getTransmitPacketCount() {
        return this.transmitPackets;
    }

    public void setReceiveByteCount(long count) {
        this.receiveBytes = count;
    }

    public long getReceiveByteCount() {
        return this.receiveBytes;
    }

    public void setTransmitByteCount(long count) {
        this.transmitBytes = count;
    }

    public long getTransmitByteCount() {
        return this.transmitBytes;
    }

    public void setReceiveDropCount(long count) {
        this.receiveDrops = count;
    }

    public long getReceiveDropCount() {
        return this.receiveDrops;
    }

    public void setTransmitDropCount(long count) {
        this.transmitDrops = count;
    }

    public long getTransmitDropCount() {
        return this.transmitDrops;
    }

    public void setReceiveErrorCount(long count) {
        this.receiveErrors = count;
    }

    public long getReceiveErrorCount() {
        return this.receiveErrors;
    }

    public void setTransmitErrorCount(long count) {
        this.transmitErrors = count;
    }

    public long getTransmitErrorCount() {
        return this.transmitErrors;
    }

    public void setReceiveFrameErrorCount(long count) {
        this.receiveFrameError = count;
    }

    public long getReceiveFrameErrorCount() {
        return this.receiveFrameError;
    }

    public void setReceiveOverRunErrorCount(long count) {
        this.receiveOverRunError = count;
    }

    public long getReceiveOverRunErrorCount() {
        return this.receiveOverRunError;
    }

    public void setReceiveCRCErrorCount(long count) {
        this.receiveCrcError = count;
    }

    public long getReceiveCRCErrorCount() {
        return this.receiveCrcError;
    }

    public void setCollisionCount(long count) {
        this.collisionCount = count;
    }

    public long getCollisionCount() {
        return this.collisionCount;
    }

    public String toString() {
        return "NodeConnectorStats[portNumber = " + this.nodeConnector + ", receivePackets = " + this.receivePackets + ", transmitPackets = " + this.transmitPackets + ", receiveBytes = " + this.receiveBytes + ", transmitBytes = " + this.transmitBytes + ", receiveDrops = " + this.receiveDrops + ", transmitDrops = " + this.transmitDrops + ", receiveErrors = " + this.receiveErrors + ", transmitErrors = " + this.transmitErrors + ", receiveFrameError = " + this.receiveFrameError + ", receiveOverRunError = " + this.receiveOverRunError + ", receiveCrcError = " + this.receiveCrcError + ", collisionCount = " + this.collisionCount + "]";
    }
}

