/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.reader;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.flowprogrammer.Flow;

@XmlRootElement(name="FlowStat")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FlowOnNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private Flow flow;
    @XmlElement
    private byte tableId;
    @XmlElement
    private int durationSeconds;
    @XmlElement
    private int durationNanoseconds;
    @XmlElement
    private long packetCount;
    @XmlElement
    private long byteCount;

    private FlowOnNode() {
    }

    public FlowOnNode(Flow flow) {
        this.flow = flow;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public void setPacketCount(long count) {
        this.packetCount = count;
    }

    public void setByteCount(long count) {
        this.byteCount = count;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public byte getTableId() {
        return this.tableId;
    }

    public void setTableId(byte tableId) {
        this.tableId = tableId;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public int getDurationNanoseconds() {
        return this.durationNanoseconds;
    }

    public void setDurationNanoseconds(int durationNanoseconds) {
        this.durationNanoseconds = durationNanoseconds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.byteCount ^ this.byteCount >>> 32);
        result = 31 * result + this.durationNanoseconds;
        result = 31 * result + this.durationSeconds;
        result = 31 * result + (this.flow == null ? 0 : this.flow.hashCode());
        result = 31 * result + (int)(this.packetCount ^ this.packetCount >>> 32);
        result = 31 * result + this.tableId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowOnNode)) {
            return false;
        }
        FlowOnNode other = (FlowOnNode)obj;
        if (this.byteCount != other.byteCount) {
            return false;
        }
        if (this.durationNanoseconds != other.durationNanoseconds) {
            return false;
        }
        if (this.durationSeconds != other.durationSeconds) {
            return false;
        }
        if (this.flow == null ? other.flow != null : !this.flow.equals(other.flow)) {
            return false;
        }
        if (this.packetCount != other.packetCount) {
            return false;
        }
        return this.tableId == other.tableId;
    }

    public String toString() {
        return "FlowOnNode[flow =" + this.flow + ", tableId = " + this.tableId + ", sec = " + this.durationSeconds + ", nsec = " + this.durationNanoseconds + ", pkt = " + this.packetCount + ", byte = " + this.byteCount + "]";
    }
}

