/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.Packet;

public class UDP
extends Packet {
    private static final String SRCPORT = "SourcePort";
    private static final String DESTPORT = "DestinationPort";
    private static final String LENGTH = "Length";
    private static final String CHECKSUM = "Checksum";
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(UDP.SRCPORT, new ImmutablePair((Object)0, (Object)16));
            this.put(UDP.DESTPORT, new ImmutablePair((Object)16, (Object)16));
            this.put(UDP.LENGTH, new ImmutablePair((Object)32, (Object)16));
            this.put(UDP.CHECKSUM, new ImmutablePair((Object)48, (Object)16));
        }
    };
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public UDP() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.setSourcePort((short)0);
        this.setDestinationPort((short)0);
        this.setChecksum((short)0);
    }

    public UDP(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.setSourcePort((short)0);
        this.setDestinationPort((short)0);
        this.setChecksum((short)0);
    }

    public short getSourcePort() {
        return BitBufferHelper.getShort(this.fieldValues.get(SRCPORT));
    }

    public short getDestinationPort() {
        return BitBufferHelper.getShort(this.fieldValues.get(DESTPORT));
    }

    public short getLength() {
        return BitBufferHelper.getShort(this.fieldValues.get(LENGTH));
    }

    public short getChecksum() {
        return BitBufferHelper.getShort(this.fieldValues.get(CHECKSUM));
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public UDP setSourcePort(short udpSourcePort) {
        byte[] sourcePort = BitBufferHelper.toByteArray(udpSourcePort);
        this.fieldValues.put(SRCPORT, sourcePort);
        return this;
    }

    public UDP setDestinationPort(short udpDestinationPort) {
        byte[] destinationPort = BitBufferHelper.toByteArray(udpDestinationPort);
        this.fieldValues.put(DESTPORT, destinationPort);
        return this;
    }

    public UDP setLength(short udpLength) {
        byte[] length = BitBufferHelper.toByteArray(udpLength);
        this.fieldValues.put(LENGTH, length);
        return this;
    }

    public UDP setChecksum(short udpChecksum) {
        byte[] checksum = BitBufferHelper.toByteArray(udpChecksum);
        this.fieldValues.put(CHECKSUM, checksum);
        return this;
    }
}

