/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.Packet;

public class TCP
extends Packet {
    public static final String SRCPORT = "SourcePort";
    public static final String DESTPORT = "DestinationPort";
    public static final String SEQNUMBER = "SequenceNumber";
    public static final String ACKNUMBER = "AcknowledgementNumber";
    public static final String DATAOFFSET = "DataOffset";
    public static final String RESERVED = "Reserved";
    public static final String HEADERLENFLAGS = "HeaderLenFlags";
    public static final String WINDOWSIZE = "WindowSize";
    public static final String CHECKSUM = "Checksum";
    public static final String URGENTPOINTER = "UrgentPointer";
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(TCP.SRCPORT, new ImmutablePair((Object)0, (Object)16));
            this.put(TCP.DESTPORT, new ImmutablePair((Object)16, (Object)16));
            this.put(TCP.SEQNUMBER, new ImmutablePair((Object)32, (Object)32));
            this.put(TCP.ACKNUMBER, new ImmutablePair((Object)64, (Object)32));
            this.put(TCP.DATAOFFSET, new ImmutablePair((Object)96, (Object)4));
            this.put(TCP.RESERVED, new ImmutablePair((Object)100, (Object)3));
            this.put(TCP.HEADERLENFLAGS, new ImmutablePair((Object)103, (Object)9));
            this.put(TCP.WINDOWSIZE, new ImmutablePair((Object)112, (Object)16));
            this.put(TCP.CHECKSUM, new ImmutablePair((Object)128, (Object)16));
            this.put(TCP.URGENTPOINTER, new ImmutablePair((Object)144, (Object)16));
        }
    };
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public TCP() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.setSourcePort((short)0);
        this.setDestinationPort((short)0);
        this.setSequenceNumber(0);
        this.setAckNumber(0);
        this.setDataOffset((byte)0);
        this.setReserved((byte)0);
        this.setWindowSize((short)0);
        this.setUrgentPointer((short)0);
        this.setChecksum((short)0);
    }

    public TCP(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.setSourcePort((short)0);
        this.setDestinationPort((short)0);
        this.setSequenceNumber(0);
        this.setAckNumber(0);
        this.setDataOffset((byte)0);
        this.setReserved((byte)0);
        this.setWindowSize((short)0);
        this.setUrgentPointer((short)0);
        this.setChecksum((short)0);
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public TCP setSourcePort(short tcpSourcePort) {
        byte[] sourcePort = BitBufferHelper.toByteArray(tcpSourcePort);
        this.fieldValues.put(SRCPORT, sourcePort);
        return this;
    }

    public TCP setDestinationPort(short tcpDestinationPort) {
        byte[] destinationPort = BitBufferHelper.toByteArray(tcpDestinationPort);
        this.fieldValues.put(DESTPORT, destinationPort);
        return this;
    }

    public TCP setSequenceNumber(int tcpSequenceNumber) {
        byte[] sequenceNumber = BitBufferHelper.toByteArray(tcpSequenceNumber);
        this.fieldValues.put(SEQNUMBER, sequenceNumber);
        return this;
    }

    public TCP setDataOffset(byte tcpDataOffset) {
        byte[] offset = BitBufferHelper.toByteArray(tcpDataOffset);
        this.fieldValues.put(DATAOFFSET, offset);
        return this;
    }

    public TCP setReserved(byte tcpReserved) {
        byte[] reserved = BitBufferHelper.toByteArray(tcpReserved);
        this.fieldValues.put(RESERVED, reserved);
        return this;
    }

    public TCP setAckNumber(int tcpAckNumber) {
        byte[] ackNumber = BitBufferHelper.toByteArray(tcpAckNumber);
        this.fieldValues.put(ACKNUMBER, ackNumber);
        return this;
    }

    public TCP setHeaderLenFlags(short tcpFlags) {
        byte[] headerLenFlags = BitBufferHelper.toByteArray(tcpFlags);
        this.fieldValues.put(HEADERLENFLAGS, headerLenFlags);
        return this;
    }

    public TCP setWindowSize(short tcpWsize) {
        byte[] wsize = BitBufferHelper.toByteArray(tcpWsize);
        this.fieldValues.put(WINDOWSIZE, wsize);
        return this;
    }

    public TCP setChecksum(short tcpChecksum) {
        byte[] checksum = BitBufferHelper.toByteArray(tcpChecksum);
        this.fieldValues.put(CHECKSUM, checksum);
        return this;
    }

    public TCP setUrgentPointer(short tcpUrgentPointer) {
        byte[] urgentPointer = BitBufferHelper.toByteArray(tcpUrgentPointer);
        this.fieldValues.put(URGENTPOINTER, urgentPointer);
        return this;
    }

    public short getSourcePort() {
        return BitBufferHelper.getShort(this.fieldValues.get(SRCPORT));
    }

    public short getDestinationPort() {
        return BitBufferHelper.getShort(this.fieldValues.get(DESTPORT));
    }
}

