/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.TimeStamp;
import org.opendaylight.controller.sal.packet.LinkEncap;

public class RawPacket {
    private byte[] packetData;
    private final LinkEncap encap;
    private final TimeStamp incomingTime;
    private final TimeStamp copyTime;
    private Map<Object, Object> props;
    private NodeConnector incomingNodeConnector;
    private NodeConnector outgoingNodeConnector;

    public NodeConnector getOutgoingNodeConnector() {
        return this.outgoingNodeConnector;
    }

    public void setOutgoingNodeConnector(NodeConnector outgoingNodeConnector) {
        this.outgoingNodeConnector = outgoingNodeConnector;
    }

    public NodeConnector getIncomingNodeConnector() {
        return this.incomingNodeConnector;
    }

    public void setIncomingNodeConnector(NodeConnector incomingNodeConnector) {
        this.incomingNodeConnector = incomingNodeConnector;
    }

    public Object getProps(Object key) {
        if (this.props != null) {
            return this.props.get(key);
        }
        return null;
    }

    public void setProps(Object key, Object value) {
        if (this.props == null) {
            this.props = new HashMap<Object, Object>();
        }
        this.props.put(key, value);
    }

    public RawPacket(byte[] data, LinkEncap e) throws ConstructionException {
        if (data == null) {
            throw new ConstructionException("Empty data");
        }
        if (e == null) {
            throw new ConstructionException("Encap not known");
        }
        this.packetData = new byte[data.length];
        System.arraycopy(data, 0, this.packetData, 0, data.length);
        this.encap = e;
        this.incomingTime = new TimeStamp(System.currentTimeMillis(), "IncomingTime");
        this.copyTime = null;
    }

    public RawPacket(RawPacket src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("null source packet");
        }
        if (src.getPacketData() == null) {
            throw new ConstructionException("Empty packetData");
        }
        this.packetData = new byte[src.getPacketData().length];
        System.arraycopy(src.getPacketData(), 0, this.packetData, 0, src.getPacketData().length);
        this.encap = src.getEncap();
        this.incomingTime = src.getIncomingTime();
        this.incomingNodeConnector = src.getIncomingNodeConnector();
        this.outgoingNodeConnector = src.getOutgoingNodeConnector();
        this.props = src.props == null ? null : new HashMap<Object, Object>(src.props);
        this.copyTime = new TimeStamp(System.currentTimeMillis(), "CopyTime");
    }

    public RawPacket(byte[] data) throws ConstructionException {
        this(data, LinkEncap.ETHERNET);
    }

    public TimeStamp getIncomingTime() {
        return this.incomingTime;
    }

    public LinkEncap getEncap() {
        return this.encap;
    }

    public byte[] getPacketData() {
        return this.packetData;
    }

    public TimeStamp getCopyTime() {
        return this.copyTime;
    }
}

