/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.BufferException;
import org.opendaylight.controller.sal.packet.PacketException;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Packet {
    protected static final Logger logger = LoggerFactory.getLogger(Packet.class);
    protected boolean writeAccess;
    protected boolean corrupted;
    protected Packet parent;
    protected Packet payload;
    protected byte[] rawPayload;
    protected Map<String, Pair<Integer, Integer>> hdrFieldCoordMap;
    protected Map<String, byte[]> hdrFieldsMap;
    protected Class<? extends Packet> payloadClass;

    public Packet() {
        this.writeAccess = false;
        this.corrupted = false;
    }

    public Packet(boolean writeAccess) {
        this.writeAccess = writeAccess;
        this.corrupted = false;
    }

    public Packet getParent() {
        return this.parent;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public void setParent(Packet parent) {
        this.parent = parent;
    }

    public void setPayload(Packet payload) {
        this.payload = payload;
    }

    public void setHeaderField(String headerField, byte[] readValue) {
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public Packet deserialize(byte[] data, int bitOffset, int size) throws PacketException {
        int startOffset = 0;
        int numBits = 0;
        for (Map.Entry<String, Pair<Integer, Integer>> pairs : this.hdrFieldCoordMap.entrySet()) {
            String hdrField = pairs.getKey();
            startOffset = bitOffset + this.getfieldOffset(hdrField);
            numBits = this.getfieldnumBits(hdrField);
            byte[] hdrFieldBytes = null;
            try {
                hdrFieldBytes = BitBufferHelper.getBits(data, startOffset, numBits);
            }
            catch (BufferException e) {
                throw new PacketException(e.getMessage());
            }
            this.setHeaderField(hdrField, hdrFieldBytes);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("{}: {}: {} (offset {} bitsize {})", new Object[]{this.getClass().getSimpleName(), hdrField, HexEncode.bytesToHexString(hdrFieldBytes), startOffset, numBits});
        }
        int payloadStart = startOffset + numBits;
        int payloadSize = data.length * 8 - payloadStart;
        if (this.payloadClass != null) {
            try {
                this.payload = this.payloadClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing payload for Ethernet packet", e);
            }
            this.payload.deserialize(data, payloadStart, payloadSize);
            this.payload.setParent(this);
        } else {
            int start = payloadStart / 8;
            int stop = start + payloadSize / 8;
            this.rawPayload = Arrays.copyOfRange(data, start, stop);
        }
        this.postDeserializeCustomOperation(data, payloadStart - this.getHeaderSize());
        return this;
    }

    public byte[] serialize() throws PacketException {
        byte[] payloadBytes = null;
        if (this.payload != null) {
            payloadBytes = this.payload.serialize();
        } else if (this.rawPayload != null) {
            payloadBytes = this.rawPayload;
        }
        int payloadSize = payloadBytes == null ? 0 : payloadBytes.length;
        int headerSize = this.getHeaderSize() / 8;
        byte[] packetBytes = new byte[headerSize + payloadSize];
        if (payloadBytes != null) {
            System.arraycopy(payloadBytes, 0, packetBytes, headerSize, payloadSize);
        }
        for (Map.Entry<String, Pair<Integer, Integer>> pairs : this.hdrFieldCoordMap.entrySet()) {
            String field = pairs.getKey();
            byte[] fieldBytes = this.hdrFieldsMap.get(field);
            if (fieldBytes == null) continue;
            try {
                BitBufferHelper.setBytes(packetBytes, fieldBytes, this.getfieldOffset(field), this.getfieldnumBits(field));
            }
            catch (BufferException e) {
                throw new PacketException(e.getMessage());
            }
        }
        this.postSerializeCustomOperation(packetBytes);
        if (logger.isTraceEnabled()) {
            logger.trace("{}: {}", (Object)this.getClass().getSimpleName(), (Object)HexEncode.bytesToHexString(packetBytes));
        }
        return packetBytes;
    }

    protected void postSerializeCustomOperation(byte[] myBytes) throws PacketException {
    }

    protected void postDeserializeCustomOperation(byte[] data, int startBitOffset) throws PacketException {
    }

    public int getHeaderSize() {
        int size = 0;
        for (Map.Entry<String, byte[]> fieldEntry : this.hdrFieldsMap.entrySet()) {
            if (fieldEntry.getValue() == null) continue;
            String field = fieldEntry.getKey();
            size += this.getfieldnumBits(field);
        }
        return size;
    }

    public int getfieldOffset(String fieldName) {
        return (Integer)this.hdrFieldCoordMap.get(fieldName).getLeft();
    }

    public int getfieldnumBits(String fieldName) {
        return (Integer)this.hdrFieldCoordMap.get(fieldName).getRight();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getClass().getSimpleName());
        ret.append(": [");
        for (String field : this.hdrFieldCoordMap.keySet()) {
            byte[] value = this.hdrFieldsMap.get(field);
            ret.append(field);
            ret.append(": ");
            ret.append(HexEncode.bytesToHexString(value));
            ret.append(", ");
        }
        ret.replace(ret.length() - 2, ret.length() - 1, "]");
        return ret.toString();
    }

    public byte[] getRawPayload() {
        return this.rawPayload;
    }

    public void setRawPayload(byte[] payload) {
        this.rawPayload = Arrays.copyOf(payload, payload.length);
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.hdrFieldsMap == null ? 0 : this.hdrFieldsMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Packet other = (Packet)obj;
        if (this.hdrFieldsMap == other.hdrFieldsMap) {
            return true;
        }
        if (this.hdrFieldsMap == null || other.hdrFieldsMap == null) {
            return false;
        }
        if (this.hdrFieldsMap != null && other.hdrFieldsMap != null) {
            for (String field : this.hdrFieldsMap.keySet()) {
                if (Arrays.equals(this.hdrFieldsMap.get(field), other.hdrFieldsMap.get(field))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

