/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.utils.HexEncode;

public class LLDPTLV
extends Packet {
    private static final String TYPE = "Type";
    private static final String LENGTH = "Length";
    private static final String VALUE = "Value";
    private static final int LLDPTLVFields = 3;
    public static final byte[] OFOUI = new byte[]{0, 38, -31};
    public static final byte[] customTlvSubType = new byte[]{0};
    public static final int customTlvOffset = OFOUI.length + customTlvSubType.length;
    public static final byte[] chassisIDSubType = new byte[]{4};
    public static final byte[] portIDSubType = new byte[]{7};
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(LLDPTLV.TYPE, new MutablePair((Object)0, (Object)7));
            this.put(LLDPTLV.LENGTH, new MutablePair((Object)7, (Object)9));
            this.put(LLDPTLV.VALUE, new MutablePair((Object)16, (Object)0));
        }
    };
    protected Map<String, byte[]> fieldValues;

    public LLDPTLV() {
        this.payload = null;
        this.fieldValues = new HashMap<String, byte[]>(3);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public LLDPTLV(LLDPTLV other) {
        for (Map.Entry entry : other.hdrFieldsMap.entrySet()) {
            this.hdrFieldsMap.put(entry.getKey(), entry.getValue());
        }
    }

    public int getLength() {
        return (int)BitBufferHelper.toNumber(this.fieldValues.get(LENGTH), (Integer)fieldCoordinates.get(LENGTH).getRight());
    }

    public byte getType() {
        return BitBufferHelper.getByte(this.fieldValues.get(TYPE));
    }

    public byte[] getValue() {
        return this.fieldValues.get(VALUE);
    }

    public LLDPTLV setType(byte type) {
        byte[] lldpTLVtype = new byte[]{type};
        this.fieldValues.put(TYPE, lldpTLVtype);
        return this;
    }

    public LLDPTLV setLength(short length) {
        this.fieldValues.put(LENGTH, BitBufferHelper.toByteArray(length));
        return this;
    }

    public LLDPTLV setValue(byte[] value) {
        this.fieldValues.put(VALUE, value);
        return this;
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        this.hdrFieldsMap.put(headerField, readValue);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldValues == null ? 0 : this.fieldValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LLDPTLV other = (LLDPTLV)obj;
        return !(this.fieldValues == null ? other.fieldValues != null : !this.fieldValues.equals(other.fieldValues));
    }

    @Override
    public int getfieldnumBits(String fieldName) {
        if (fieldName.equals(VALUE)) {
            return 8 * BitBufferHelper.getShort(this.fieldValues.get(LENGTH), (Integer)fieldCoordinates.get(LENGTH).getRight());
        }
        return (Integer)fieldCoordinates.get(fieldName).getRight();
    }

    public int getTLVSize() {
        return (Integer)fieldCoordinates.get(TYPE).getRight() + (Integer)fieldCoordinates.get(LENGTH).getRight() + this.getfieldnumBits(VALUE);
    }

    public static byte[] createSystemNameTLVValue(String nodeId) {
        byte[] nid = nodeId.getBytes();
        return nid;
    }

    public static byte[] createChassisIDTLVValue(String nodeId) {
        byte[] nid = HexEncode.bytesFromHexString(nodeId);
        byte[] cid = new byte[6];
        int srcPos = 0;
        int dstPos = 0;
        if (nid.length > cid.length) {
            srcPos = nid.length - cid.length;
        } else {
            dstPos = cid.length - nid.length;
        }
        System.arraycopy(nid, srcPos, cid, dstPos, cid.length);
        byte[] cidValue = new byte[cid.length + chassisIDSubType.length];
        System.arraycopy(chassisIDSubType, 0, cidValue, 0, chassisIDSubType.length);
        System.arraycopy(cid, 0, cidValue, chassisIDSubType.length, cid.length);
        return cidValue;
    }

    public static byte[] createPortIDTLVValue(String portId) {
        byte[] pid = portId.getBytes(Charset.defaultCharset());
        byte[] pidValue = new byte[pid.length + portIDSubType.length];
        System.arraycopy(portIDSubType, 0, pidValue, 0, portIDSubType.length);
        System.arraycopy(pid, 0, pidValue, portIDSubType.length, pid.length);
        return pidValue;
    }

    public static byte[] createCustomTLVValue(String customString) {
        byte[] customArray = customString.getBytes(Charset.defaultCharset());
        byte[] customValue = new byte[customTlvOffset + customArray.length];
        System.arraycopy(OFOUI, 0, customValue, 0, OFOUI.length);
        System.arraycopy(customTlvSubType, 0, customValue, OFOUI.length, customTlvSubType.length);
        System.arraycopy(customArray, 0, customValue, customTlvOffset, customArray.length);
        return customValue;
    }

    public static String getHexStringValue(byte[] tlvValue, int tlvLen) {
        byte[] cidBytes = new byte[tlvLen - chassisIDSubType.length];
        System.arraycopy(tlvValue, chassisIDSubType.length, cidBytes, 0, cidBytes.length);
        return HexEncode.bytesToHexStringFormat(cidBytes);
    }

    public static String getStringValue(byte[] tlvValue, int tlvLen) {
        byte[] pidBytes = new byte[tlvLen - portIDSubType.length];
        System.arraycopy(tlvValue, portIDSubType.length, pidBytes, 0, pidBytes.length);
        return new String(pidBytes, Charset.defaultCharset());
    }

    public static String getCustomString(byte[] customTlvValue, int customTlvLen) {
        String customString = "";
        byte[] vendor = new byte[3];
        System.arraycopy(customTlvValue, 0, vendor, 0, vendor.length);
        if (Arrays.equals(vendor, OFOUI)) {
            int customArrayLength = customTlvLen - customTlvOffset;
            byte[] customArray = new byte[customArrayLength];
            System.arraycopy(customTlvValue, customTlvOffset, customArray, 0, customArrayLength);
            try {
                customString = new String(customArray, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return customString;
    }

    public static enum TLVType {
        Unknown(0),
        ChassisID(1),
        PortID(2),
        TTL(3),
        PortDesc(4),
        SystemName(5),
        SystemDesc(6),
        Custom(127);

        private byte value;

        private TLVType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

