/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.BufferException;
import org.opendaylight.controller.sal.packet.LLDPTLV;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketException;
import org.opendaylight.controller.sal.utils.HexEncode;

public class LLDP
extends Packet {
    private static final String CHASSISID = "ChassisId";
    private static final String SYSTEMNAMEID = "SystemNameID";
    private static final String PORTID = "PortId";
    private static final String TTL = "TTL";
    private static final int LLDPDefaultTlvs = 4;
    private static LLDPTLV emptyTLV = new LLDPTLV().setLength((short)0).setType((byte)0);
    public static final byte[] LLDPMulticastMac = new byte[]{1, -128, -62, 0, 0, 14};
    private Map<Byte, LLDPTLV> tlvList = new LinkedHashMap<Byte, LLDPTLV>(4);

    public LLDP() {
    }

    public LLDP(boolean writeAccess) {
        super(writeAccess);
    }

    private byte getType(String typeDesc) {
        if (typeDesc.equals(CHASSISID)) {
            return LLDPTLV.TLVType.ChassisID.getValue();
        }
        if (typeDesc.equals(PORTID)) {
            return LLDPTLV.TLVType.PortID.getValue();
        }
        if (typeDesc.equals(TTL)) {
            return LLDPTLV.TLVType.TTL.getValue();
        }
        return LLDPTLV.TLVType.Unknown.getValue();
    }

    public LLDPTLV getTLV(String type) {
        return this.tlvList.get(this.getType(type));
    }

    public void setTLV(String type, LLDPTLV tlv) {
        this.tlvList.put(this.getType(type), tlv);
    }

    public LLDPTLV getChassisId() {
        return this.getTLV(CHASSISID);
    }

    public LLDP setChassisId(LLDPTLV chassisId) {
        this.tlvList.put(this.getType(CHASSISID), chassisId);
        return this;
    }

    public LLDPTLV getSystemNameId() {
        return this.getTLV(SYSTEMNAMEID);
    }

    public LLDP setSystemNameId(LLDPTLV systemNameId) {
        this.tlvList.put(this.getType(SYSTEMNAMEID), systemNameId);
        return this;
    }

    public LLDPTLV getPortId() {
        return this.tlvList.get(this.getType(PORTID));
    }

    public LLDP setPortId(LLDPTLV portId) {
        this.tlvList.put(this.getType(PORTID), portId);
        return this;
    }

    public LLDPTLV getTtl() {
        return this.tlvList.get(this.getType(TTL));
    }

    public LLDP setTtl(LLDPTLV ttl) {
        this.tlvList.put(this.getType(TTL), ttl);
        return this;
    }

    public List<LLDPTLV> getOptionalTLVList() {
        ArrayList<LLDPTLV> list = new ArrayList<LLDPTLV>();
        for (Map.Entry<Byte, LLDPTLV> entry : this.tlvList.entrySet()) {
            byte type = entry.getKey();
            if (type == LLDPTLV.TLVType.ChassisID.getValue() || type == LLDPTLV.TLVType.PortID.getValue() || type == LLDPTLV.TLVType.TTL.getValue()) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public LLDP setOptionalTLVList(List<LLDPTLV> optionalTLVList) {
        for (LLDPTLV tlv : optionalTLVList) {
            this.tlvList.put(tlv.getType(), tlv);
        }
        return this;
    }

    @Override
    public Packet deserialize(byte[] data, int bitOffset, int size) throws PacketException {
        int lldpOffset = bitOffset;
        int lldpSize = size;
        if (logger.isTraceEnabled()) {
            logger.trace("LLDP: {} (offset {} bitsize {})", new Object[]{HexEncode.bytesToHexString(data), lldpOffset, lldpSize});
        }
        while (lldpSize > 0) {
            LLDPTLV tlv = new LLDPTLV();
            tlv.deserialize(data, lldpOffset, lldpSize);
            int tlvSize = tlv.getTLVSize();
            lldpOffset += tlvSize;
            lldpSize -= tlvSize;
            this.tlvList.put(tlv.getType(), tlv);
        }
        return this;
    }

    @Override
    public byte[] serialize() throws PacketException {
        int startOffset = 0;
        byte[] serializedBytes = new byte[this.getLLDPPacketLength()];
        for (Map.Entry<Byte, LLDPTLV> entry : this.tlvList.entrySet()) {
            LLDPTLV tlv = entry.getValue();
            int numBits = tlv.getTLVSize();
            try {
                BitBufferHelper.setBytes(serializedBytes, tlv.serialize(), startOffset, numBits);
            }
            catch (BufferException e) {
                throw new PacketException(e.getMessage());
            }
            startOffset += numBits;
        }
        try {
            BitBufferHelper.setBytes(serializedBytes, emptyTLV.serialize(), startOffset, emptyTLV.getTLVSize());
        }
        catch (BufferException e) {
            throw new PacketException(e.getMessage());
        }
        if (logger.isTraceEnabled()) {
            logger.trace("LLDP: serialized: {}", (Object)HexEncode.bytesToHexString(serializedBytes));
        }
        return serializedBytes;
    }

    private int getLLDPPacketLength() {
        int len = 0;
        for (Map.Entry<Byte, LLDPTLV> entry : this.tlvList.entrySet()) {
            LLDPTLV tlv = entry.getValue();
            len += tlv.getTLVSize();
        }
        return (len += emptyTLV.getTLVSize()) / 8;
    }
}

