/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.BufferException;
import org.opendaylight.controller.sal.packet.ICMP;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketException;
import org.opendaylight.controller.sal.packet.TCP;
import org.opendaylight.controller.sal.packet.UDP;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPv4
extends Packet {
    protected static final Logger logger = LoggerFactory.getLogger(IPv4.class);
    private static final String VERSION = "Version";
    private static final String HEADERLENGTH = "HeaderLength";
    private static final String DIFFSERV = "DiffServ";
    private static final String ECN = "ECN";
    private static final String TOTLENGTH = "TotalLength";
    private static final String IDENTIFICATION = "Identification";
    private static final String FLAGS = "Flags";
    private static final String FRAGOFFSET = "FragmentOffset";
    private static final String TTL = "TTL";
    private static final String PROTOCOL = "Protocol";
    private static final String CHECKSUM = "Checksum";
    private static final String SIP = "SourceIPAddress";
    private static final String DIP = "DestinationIPAddress";
    private static final String OPTIONS = "Options";
    private static final int UNIT_SIZE_SHIFT = 2;
    private static final int UNIT_SIZE = 4;
    private static final int MIN_HEADER_SIZE = 20;
    public static final Map<Byte, Class<? extends Packet>> protocolClassMap = new HashMap<Byte, Class<? extends Packet>>();
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates;
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public IPv4() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.corrupted = false;
        this.setVersion((byte)4);
        this.setHeaderLength((byte)5);
        this.setDiffServ((byte)0);
        this.setECN((byte)0);
        this.setIdentification(this.generateId());
        this.setFlags((byte)2);
        this.setFragmentOffset((short)0);
    }

    public IPv4(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
        this.corrupted = false;
        this.setVersion((byte)4);
        this.setHeaderLength((byte)5);
        this.setDiffServ((byte)0);
        this.setECN((byte)0);
        this.setIdentification(this.generateId());
        this.setFlags((byte)2);
        this.setFragmentOffset((short)0);
    }

    public byte getVersion() {
        return BitBufferHelper.getByte(this.fieldValues.get(VERSION));
    }

    public int getHeaderLen() {
        return 4 * BitBufferHelper.getByte(this.fieldValues.get(HEADERLENGTH));
    }

    @Override
    public int getHeaderSize() {
        int headerLen = this.getHeaderLen();
        if (headerLen == 0) {
            headerLen = 20;
        }
        return headerLen * 8;
    }

    public byte getDiffServ() {
        return BitBufferHelper.getByte(this.fieldValues.get(DIFFSERV));
    }

    public byte getECN() {
        return BitBufferHelper.getByte(this.fieldValues.get(ECN));
    }

    public short getTotalLength() {
        return BitBufferHelper.getShort(this.fieldValues.get(TOTLENGTH));
    }

    public short getIdentification() {
        return BitBufferHelper.getShort(this.fieldValues.get(IDENTIFICATION));
    }

    public byte getFlags() {
        return BitBufferHelper.getByte(this.fieldValues.get(FLAGS));
    }

    public byte getTtl() {
        return BitBufferHelper.getByte(this.fieldValues.get(TTL));
    }

    public byte getProtocol() {
        return BitBufferHelper.getByte(this.fieldValues.get(PROTOCOL));
    }

    public short getChecksum() {
        return BitBufferHelper.getShort(this.fieldValues.get(CHECKSUM));
    }

    public short getFragmentOffset() {
        return BitBufferHelper.getShort(this.fieldValues.get(FRAGOFFSET));
    }

    public int getSourceAddress() {
        return BitBufferHelper.getInt(this.fieldValues.get(SIP));
    }

    public int getDestinationAddress() {
        return BitBufferHelper.getInt(this.fieldValues.get(DIP));
    }

    public byte[] getOptions() {
        return this.fieldValues.get(OPTIONS);
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        if (headerField.equals(PROTOCOL)) {
            this.payloadClass = protocolClassMap.get(readValue[0]);
        } else if (headerField.equals(OPTIONS) && (readValue == null || readValue.length == 0)) {
            this.hdrFieldsMap.remove(headerField);
            return;
        }
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public IPv4 setVersion(byte ipVersion) {
        byte[] version = BitBufferHelper.toByteArray(ipVersion);
        this.fieldValues.put(VERSION, version);
        return this;
    }

    public IPv4 setHeaderLength(byte ipheaderLength) {
        byte[] headerLength = BitBufferHelper.toByteArray(ipheaderLength);
        this.fieldValues.put(HEADERLENGTH, headerLength);
        return this;
    }

    public IPv4 setDiffServ(byte ipdiffServ) {
        byte[] diffServ = BitBufferHelper.toByteArray(ipdiffServ);
        this.fieldValues.put(DIFFSERV, diffServ);
        return this;
    }

    public IPv4 setECN(byte ecn) {
        byte[] ecnbytes = BitBufferHelper.toByteArray(ecn);
        this.fieldValues.put(ECN, ecnbytes);
        return this;
    }

    public IPv4 setTotalLength(short iptotalLength) {
        byte[] totalLength = BitBufferHelper.toByteArray(iptotalLength);
        this.fieldValues.put(TOTLENGTH, totalLength);
        return this;
    }

    public IPv4 setIdentification(short ipIdentification) {
        byte[] identification = BitBufferHelper.toByteArray(ipIdentification);
        this.fieldValues.put(IDENTIFICATION, identification);
        return this;
    }

    public IPv4 setFlags(byte ipFlags) {
        byte[] flags = new byte[]{ipFlags};
        this.fieldValues.put(FLAGS, flags);
        return this;
    }

    public IPv4 setFragmentOffset(short ipFragmentOffset) {
        byte[] fragmentOffset = BitBufferHelper.toByteArray(ipFragmentOffset);
        this.fieldValues.put(FRAGOFFSET, fragmentOffset);
        return this;
    }

    public IPv4 setTtl(byte ipTtl) {
        byte[] ttl = BitBufferHelper.toByteArray(ipTtl);
        this.fieldValues.put(TTL, ttl);
        return this;
    }

    public IPv4 setProtocol(byte ipProtocol) {
        byte[] protocol = BitBufferHelper.toByteArray(ipProtocol);
        this.fieldValues.put(PROTOCOL, protocol);
        return this;
    }

    public IPv4 setSourceAddress(InetAddress ipSourceAddress) {
        byte[] sourceAddress = ipSourceAddress.getAddress();
        this.fieldValues.put(SIP, sourceAddress);
        return this;
    }

    public IPv4 setDestinationAddress(InetAddress ipDestinationAddress) {
        byte[] sourceAddress = ipDestinationAddress.getAddress();
        this.fieldValues.put(DIP, sourceAddress);
        return this;
    }

    public IPv4 setDestinationAddress(int ipDestinationAddress) {
        byte[] destinationAddress = BitBufferHelper.toByteArray(ipDestinationAddress);
        this.fieldValues.put(DIP, destinationAddress);
        return this;
    }

    private short generateId() {
        Random randomgen = new Random();
        return (short)randomgen.nextInt(32768);
    }

    public IPv4 setOptions(byte[] options) {
        byte newIHL = 5;
        if (options == null || options.length == 0) {
            this.fieldValues.remove(OPTIONS);
        } else {
            int len = options.length;
            int rlen = len + 3 & 0xFFFFFFFC;
            if (rlen > len) {
                byte[] newopt = new byte[rlen];
                System.arraycopy(options, 0, newopt, 0, len);
                options = newopt;
                len = rlen;
            }
            this.fieldValues.put(OPTIONS, options);
            newIHL = (byte)(newIHL + (len >>> 2));
        }
        this.setHeaderLength(newIHL);
        return this;
    }

    short computeChecksum(byte[] data, int start) {
        int end = start + this.getHeaderLen();
        short checkSum = 0;
        int sum = 0;
        int carry = 0;
        int finalSum = 0;
        int checksumStart = start + this.getfieldOffset(CHECKSUM) / 8;
        for (int i = start; i <= end - 1; i += 2) {
            if (i == checksumStart) continue;
            int wordData = (data[i] << 8 & 0xFF00) + (data[i + 1] & 0xFF);
            sum += wordData;
        }
        carry = sum >> 16 & 0xFF;
        finalSum = (sum & 0xFFFF) + carry;
        checkSum = (short)(~((short)finalSum & 0xFFFF));
        return checkSum;
    }

    @Override
    public int getfieldnumBits(String fieldName) {
        if (fieldName.equals(OPTIONS)) {
            return (this.getHeaderLen() - 20) * 8;
        }
        return (Integer)((Pair)this.hdrFieldCoordMap.get(fieldName)).getRight();
    }

    @Override
    protected void postSerializeCustomOperation(byte[] data) throws PacketException {
        byte[] totalLength = BitBufferHelper.toByteArray((short)data.length);
        try {
            BitBufferHelper.setBytes(data, totalLength, this.getfieldOffset(TOTLENGTH), this.getfieldnumBits(TOTLENGTH));
        }
        catch (BufferException e) {
            throw new PacketException(e.getMessage());
        }
        byte[] checkSum = BitBufferHelper.toByteArray(this.computeChecksum(data, 0));
        try {
            BitBufferHelper.setBytes(data, checkSum, this.getfieldOffset(CHECKSUM), this.getfieldnumBits(CHECKSUM));
        }
        catch (BufferException e) {
            throw new PacketException(e.getMessage());
        }
    }

    @Override
    public void setPayload(Packet payload) {
        this.payload = payload;
        int payloadLength = 0;
        if (payload != null) {
            try {
                payloadLength = payload.serialize().length;
            }
            catch (PacketException e) {
                logger.error("", (Throwable)e);
            }
        }
        this.setTotalLength((short)(this.getHeaderLen() + payloadLength));
    }

    @Override
    protected void postDeserializeCustomOperation(byte[] data, int startBitOffset) {
        short actualChecksum;
        int start = startBitOffset / 8;
        short computedChecksum = this.computeChecksum(data, start);
        if (computedChecksum != (actualChecksum = BitBufferHelper.getShort(this.fieldValues.get(CHECKSUM)))) {
            this.corrupted = true;
        }
    }

    static {
        protocolClassMap.put(IPProtocols.ICMP.byteValue(), ICMP.class);
        protocolClassMap.put(IPProtocols.UDP.byteValue(), UDP.class);
        protocolClassMap.put(IPProtocols.TCP.byteValue(), TCP.class);
        fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(IPv4.VERSION, new ImmutablePair((Object)0, (Object)4));
                this.put(IPv4.HEADERLENGTH, new ImmutablePair((Object)4, (Object)4));
                this.put(IPv4.DIFFSERV, new ImmutablePair((Object)8, (Object)6));
                this.put(IPv4.ECN, new ImmutablePair((Object)14, (Object)2));
                this.put(IPv4.TOTLENGTH, new ImmutablePair((Object)16, (Object)16));
                this.put(IPv4.IDENTIFICATION, new ImmutablePair((Object)32, (Object)16));
                this.put(IPv4.FLAGS, new ImmutablePair((Object)48, (Object)3));
                this.put(IPv4.FRAGOFFSET, new ImmutablePair((Object)51, (Object)13));
                this.put(IPv4.TTL, new ImmutablePair((Object)64, (Object)8));
                this.put(IPv4.PROTOCOL, new ImmutablePair((Object)72, (Object)8));
                this.put(IPv4.CHECKSUM, new ImmutablePair((Object)80, (Object)16));
                this.put(IPv4.SIP, new ImmutablePair((Object)96, (Object)32));
                this.put(IPv4.DIP, new ImmutablePair((Object)128, (Object)32));
                this.put(IPv4.OPTIONS, new ImmutablePair((Object)160, (Object)0));
            }
        };
    }
}

