/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.Packet;

public class IEEE8021Q
extends Packet {
    private static final String PCP = "PriorityCodePoint";
    private static final String CFI = "CanonicalFormatIndicator";
    private static final String VID = "VlanIdentifier";
    private static final String ETHT = "EtherType";
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(IEEE8021Q.PCP, new ImmutablePair((Object)0, (Object)3));
            this.put(IEEE8021Q.CFI, new ImmutablePair((Object)3, (Object)1));
            this.put(IEEE8021Q.VID, new ImmutablePair((Object)4, (Object)12));
            this.put(IEEE8021Q.ETHT, new ImmutablePair((Object)16, (Object)16));
        }
    };
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public IEEE8021Q() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public IEEE8021Q(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        if (headerField.equals(ETHT)) {
            this.payloadClass = Ethernet.etherTypeClassMap.get(BitBufferHelper.getShort(readValue));
        }
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public byte getPcp() {
        return BitBufferHelper.getByte(this.fieldValues.get(PCP));
    }

    public byte getCfi() {
        return BitBufferHelper.getByte(this.fieldValues.get(CFI));
    }

    public short getVid() {
        return BitBufferHelper.getShort(this.fieldValues.get(VID));
    }

    public short getEtherType() {
        return BitBufferHelper.getShort(this.fieldValues.get(ETHT));
    }

    public IEEE8021Q setPcp(byte pcp) {
        byte[] priorityCodePoint = BitBufferHelper.toByteArray(pcp);
        this.fieldValues.put(PCP, priorityCodePoint);
        return this;
    }

    public IEEE8021Q setCfi(byte cfi) {
        byte[] canonicalFormatIndicator = BitBufferHelper.toByteArray(cfi);
        this.fieldValues.put(CFI, canonicalFormatIndicator);
        return this;
    }

    public IEEE8021Q setVid(short vid) {
        byte[] vlanIdentifier = BitBufferHelper.toByteArray(vid);
        this.fieldValues.put(VID, vlanIdentifier);
        return this;
    }

    public IEEE8021Q setEtherType(short etherType) {
        byte[] ethType = BitBufferHelper.toByteArray(etherType);
        this.fieldValues.put(ETHT, ethType);
        return this;
    }
}

