/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.BufferException;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketException;

public class ICMP
extends Packet {
    private static final String TYPE = "Type";
    private static final String CODE = "Code";
    private static final String CHECKSUM = "Checksum";
    private static final String IDENTIFIER = "Identifier";
    private static final String SEQNUMBER = "SequenceNumber";
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ICMP.TYPE, new ImmutablePair((Object)0, (Object)8));
            this.put(ICMP.CODE, new ImmutablePair((Object)8, (Object)8));
            this.put(ICMP.CHECKSUM, new ImmutablePair((Object)16, (Object)16));
            this.put(ICMP.IDENTIFIER, new ImmutablePair((Object)32, (Object)16));
            this.put(ICMP.SEQNUMBER, new ImmutablePair((Object)48, (Object)16));
        }
    };
    private final Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public ICMP() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public ICMP(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    @Override
    public void setHeaderField(String headerField, byte[] readValue) {
        this.hdrFieldsMap.put(headerField, readValue);
    }

    public ICMP setType(byte type) {
        byte[] icmpType = BitBufferHelper.toByteArray(type);
        this.fieldValues.put(TYPE, icmpType);
        return this;
    }

    public byte getType() {
        return BitBufferHelper.getByte(this.fieldValues.get(TYPE));
    }

    public ICMP setCode(byte code) {
        byte[] icmpCode = BitBufferHelper.toByteArray(code);
        this.fieldValues.put(CODE, icmpCode);
        return this;
    }

    public byte getCode() {
        return BitBufferHelper.getByte(this.fieldValues.get(CODE));
    }

    public ICMP setChecksum(short checksum) {
        byte[] icmpChecksum = BitBufferHelper.toByteArray(checksum);
        this.fieldValues.put(CHECKSUM, icmpChecksum);
        return this;
    }

    public ICMP setIdentifier(short identifier) {
        byte[] icmpIdentifier = BitBufferHelper.toByteArray(identifier);
        this.fieldValues.put(IDENTIFIER, icmpIdentifier);
        return this;
    }

    public short getIdentifier() {
        return BitBufferHelper.getShort(this.fieldValues.get(IDENTIFIER));
    }

    public ICMP setSequenceNumber(short seqNumber) {
        byte[] icmpSeqNumber = BitBufferHelper.toByteArray(seqNumber);
        this.fieldValues.put(SEQNUMBER, icmpSeqNumber);
        return this;
    }

    public short getSequenceNumber() {
        return BitBufferHelper.getShort(this.fieldValues.get(SEQNUMBER));
    }

    @Override
    public int getHeaderSize() {
        return 64;
    }

    short computeChecksum(byte[] data, int start) {
        int sum = 0;
        int carry = 0;
        int finalSum = 0;
        int end = start + this.getHeaderSize() / 8;
        if (this.rawPayload != null) {
            end += this.rawPayload.length;
        }
        int checksumStartByte = start + this.getfieldOffset(CHECKSUM) / 8;
        for (int i = start; i <= end - 1; i += 2) {
            if (i == checksumStartByte) continue;
            int wordData = (data[i] << 8 & 0xFF00) + (data[i + 1] & 0xFF);
            sum += wordData;
        }
        carry = sum >> 16 & 0xFF;
        finalSum = (sum & 0xFFFF) + carry;
        return (short)(~((short)finalSum & 0xFFFF));
    }

    @Override
    protected void postSerializeCustomOperation(byte[] serializedBytes) throws PacketException {
        byte[] checkSum = BitBufferHelper.toByteArray(this.computeChecksum(serializedBytes, 0));
        try {
            BitBufferHelper.setBytes(serializedBytes, checkSum, this.getfieldOffset(CHECKSUM), this.getfieldnumBits(CHECKSUM));
        }
        catch (BufferException e) {
            throw new PacketException(e.getMessage());
        }
    }

    @Override
    protected void postDeserializeCustomOperation(byte[] data, int endBitOffset) {
        short actualChecksum;
        short computedChecksum = this.computeChecksum(data, endBitOffset / 8);
        if (computedChecksum != (actualChecksum = BitBufferHelper.getShort(this.fieldValues.get(CHECKSUM)))) {
            this.corrupted = true;
        }
    }

    public short getChecksum() {
        return BitBufferHelper.getShort(this.fieldValues.get(CHECKSUM));
    }
}

