/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.Arrays;
import org.opendaylight.controller.sal.packet.BufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BitBufferHelper {
    protected static final Logger logger = LoggerFactory.getLogger(BitBufferHelper.class);
    public static final long ByteMask = 255L;

    public static byte getByte(byte[] data) {
        if (data.length * 8 > 8) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        return data[0];
    }

    public static short getShort(byte[] data) {
        if (data.length > 16) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        return (short)BitBufferHelper.toNumber(data);
    }

    public static int getInt(byte[] data) {
        if (data.length > 32) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        return (int)BitBufferHelper.toNumber(data);
    }

    public static long getLong(byte[] data) {
        if (data.length > 64) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return BitBufferHelper.toNumber(data);
    }

    public static short getShort(byte[] data, int numBits) {
        if (numBits > 16) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        int startOffset = data.length * 8 - numBits;
        byte[] bits = null;
        try {
            bits = BitBufferHelper.getBits(data, startOffset, numBits);
        }
        catch (BufferException e) {
            logger.error("", (Throwable)e);
        }
        return (short)BitBufferHelper.toNumber(bits, numBits);
    }

    public static int getInt(byte[] data, int numBits) {
        if (numBits > 32) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        int startOffset = data.length * 8 - numBits;
        byte[] bits = null;
        try {
            bits = BitBufferHelper.getBits(data, startOffset, numBits);
        }
        catch (BufferException e) {
            logger.error("", (Throwable)e);
        }
        return (int)BitBufferHelper.toNumber(bits, numBits);
    }

    public static long getLong(byte[] data, int numBits) {
        if (numBits > 64) {
            try {
                throw new BufferException("Container is too small for the number of requested bits");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        if (numBits > data.length * 8) {
            try {
                throw new BufferException("Trying to read more bits than contained in the data buffer");
            }
            catch (BufferException e) {
                logger.error("", (Throwable)e);
            }
        }
        int startOffset = data.length * 8 - numBits;
        byte[] bits = null;
        try {
            bits = BitBufferHelper.getBits(data, startOffset, numBits);
        }
        catch (BufferException e) {
            logger.error("", (Throwable)e);
        }
        return BitBufferHelper.toNumber(bits, numBits);
    }

    public static byte[] getBits(byte[] data, int startOffset, int numBits) throws BufferException {
        int startByteOffset = 0;
        int extranumBits = numBits % 8;
        int extraOffsetBits = startOffset % 8;
        int numBytes = numBits % 8 != 0 ? 1 + numBits / 8 : numBits / 8;
        byte[] shiftedBytes = new byte[numBytes];
        startByteOffset = startOffset / 8;
        byte[] bytes = new byte[numBytes];
        if (numBits == 0) {
            return bytes;
        }
        BitBufferHelper.checkExceptions(data, startOffset, numBits);
        if (extraOffsetBits == 0) {
            if (extranumBits == 0) {
                System.arraycopy(data, startByteOffset, bytes, 0, numBytes);
                return bytes;
            }
            System.arraycopy(data, startByteOffset, bytes, 0, numBytes - 1);
            bytes[numBytes - 1] = (byte)(data[startByteOffset + numBytes - 1] & BitBufferHelper.getMSBMask(extranumBits));
        } else {
            int valfromnext;
            int valfromcurr;
            int i;
            for (i = 0; i < numBits / 8; ++i) {
                valfromcurr = data[startByteOffset + i] & BitBufferHelper.getLSBMask(8 - extraOffsetBits);
                valfromnext = data[startByteOffset + i + 1] & BitBufferHelper.getMSBMask(extraOffsetBits);
                bytes[i] = (byte)(valfromcurr << extraOffsetBits | valfromnext >> 8 - extraOffsetBits);
            }
            if (extranumBits != 0) {
                if (extranumBits < 8 - extraOffsetBits) {
                    valfromnext = data[startByteOffset + i] & BitBufferHelper.getMSBMask(extranumBits) >> extraOffsetBits;
                    bytes[i] = (byte)(valfromnext << extraOffsetBits);
                } else if (extranumBits == 8 - extraOffsetBits) {
                    valfromcurr = data[startByteOffset + i] & BitBufferHelper.getLSBMask(8 - extraOffsetBits);
                    bytes[i] = (byte)(valfromcurr << extraOffsetBits);
                } else {
                    valfromcurr = data[startByteOffset + i] & BitBufferHelper.getLSBMask(8 - extraOffsetBits);
                    valfromnext = data[startByteOffset + i + 1] & BitBufferHelper.getMSBMask(extranumBits - (8 - extraOffsetBits));
                    bytes[i] = (byte)(valfromcurr << extraOffsetBits | valfromnext >> 8 - extraOffsetBits);
                }
            }
        }
        shiftedBytes = BitBufferHelper.shiftBitsToLSB(bytes, numBits);
        return shiftedBytes;
    }

    public static void setByte(byte[] data, byte input, int startOffset, int numBits) throws BufferException {
        byte[] inputByteArray = new byte[1];
        Arrays.fill(inputByteArray, 0, 1, input);
        BitBufferHelper.setBytes(data, inputByteArray, startOffset, numBits);
    }

    public static void setBytes(byte[] data, byte[] input, int startOffset, int numBits) throws BufferException {
        BitBufferHelper.checkExceptions(data, startOffset, numBits);
        BitBufferHelper.insertBits(data, input, startOffset, numBits);
    }

    public static int getMSBMask(int numBits) {
        int mask = 0;
        for (int i = 0; i < numBits; ++i) {
            mask |= 1 << 7 - i;
        }
        return mask;
    }

    public static int getLSBMask(int numBits) {
        int mask = 0;
        for (int i = 0; i < numBits; ++i) {
            mask |= 1 << i;
        }
        return mask;
    }

    public static long toNumber(byte[] array) {
        long ret = 0L;
        long length = array.length;
        int value = 0;
        int i = 0;
        while ((long)i < length) {
            value = array[i];
            if (value < 0) {
                value += 256;
            }
            ret |= (long)value << (int)((length - (long)i - 1L) * 8L);
            ++i;
        }
        return ret;
    }

    public static long toNumber(byte[] array, int numBits) {
        int length = numBits / 8;
        int bitsRest = numBits % 8;
        int startOffset = array.length - length;
        long ret = 0L;
        int value = 0;
        value = array[startOffset - 1] & BitBufferHelper.getLSBMask(bitsRest);
        value = array[startOffset - 1] < 0 ? array[startOffset - 1] + 256 : array[startOffset - 1];
        ret |= (long)(value << (array.length - startOffset) * 8);
        for (int i = startOffset; i < array.length; ++i) {
            value = array[i];
            if (value < 0) {
                value += 256;
            }
            ret |= (long)value << (array.length - i - 1) * 8;
        }
        return ret;
    }

    public static byte[] toByteArray(Number input) {
        Class<?> dataType = input.getClass();
        int size = 0;
        long longValue = input.longValue();
        if (dataType == Byte.class || dataType == Byte.TYPE) {
            size = 8;
        } else if (dataType == Short.class || dataType == Short.TYPE) {
            size = 16;
        } else if (dataType == Integer.class || dataType == Integer.TYPE) {
            size = 32;
        } else if (dataType == Long.class || dataType == Long.TYPE) {
            size = 64;
        } else {
            throw new IllegalArgumentException("Parameter must one of the following: Short/Int/Long\n");
        }
        int length = size / 8;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(longValue >> 8 * (length - i - 1) & 0xFFL);
        }
        return bytes;
    }

    public static byte[] toByteArray(Number input, int numBits) {
        Class<?> dataType = input.getClass();
        int size = 0;
        long longValue = input.longValue();
        if (dataType == Short.class) {
            size = 16;
        } else if (dataType == Integer.class) {
            size = 32;
        } else if (dataType == Long.class) {
            size = 64;
        } else {
            throw new IllegalArgumentException("Parameter must one of the following: Short/Int/Long\n");
        }
        int length = size / 8;
        byte[] bytes = new byte[length];
        byte[] inputbytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(longValue >> 8 * (length - i - 1) & 0xFFL);
        }
        if (bytes[0] == 0 && dataType == Long.class || bytes[0] == 0 && dataType == Integer.class) {
            int index = 0;
            for (index = 0; index < length; ++index) {
                if (bytes[index] == 0) continue;
                bytes[0] = bytes[index];
                break;
            }
            System.arraycopy(bytes, index, inputbytes, 0, length - index);
            Arrays.fill(bytes, length - index + 1, length - 1, (byte)0);
        } else {
            System.arraycopy(bytes, 0, inputbytes, 0, length);
        }
        byte[] shiftedBytes = BitBufferHelper.shiftBitsToMSB(inputbytes, numBits);
        return shiftedBytes;
    }

    public static byte[] shiftBitsToMSB(byte[] inputBytes, int numBits) {
        int i;
        int numBitstoShiftBy = 0;
        int leadZeroesMSB = 8;
        int numEndRestBits = 0;
        int size = inputBytes.length;
        byte[] shiftedBytes = new byte[size];
        for (i = 0; i < 8; ++i) {
            if ((byte)(inputBytes[0] & BitBufferHelper.getMSBMask(i + 1)) == 0) continue;
            leadZeroesMSB = i;
            break;
        }
        if (numBits % 8 == 0) {
            numBitstoShiftBy = 0;
        } else {
            int n = numBitstoShiftBy = 8 - numBits % 8 < leadZeroesMSB ? 8 - numBits % 8 : leadZeroesMSB;
        }
        if (numBitstoShiftBy == 0) {
            return inputBytes;
        }
        if (numBits < 8) {
            shiftedBytes[0] = (byte)((inputBytes[0] & BitBufferHelper.getLSBMask(numBits)) << numBitstoShiftBy);
        } else {
            numEndRestBits = 8 - (inputBytes.length * 8 - numBits - numBitstoShiftBy);
            for (i = 0; i < size - 1; ++i) {
                if (i + 1 == size - 1) {
                    if (numEndRestBits > numBitstoShiftBy) {
                        shiftedBytes[i] = (byte)(inputBytes[i] << numBitstoShiftBy | (inputBytes[i + 1] & BitBufferHelper.getMSBMask(numBitstoShiftBy)) >> numEndRestBits - numBitstoShiftBy);
                        shiftedBytes[i + 1] = (byte)((inputBytes[i + 1] & BitBufferHelper.getLSBMask(numEndRestBits - numBitstoShiftBy)) << numBitstoShiftBy);
                    } else {
                        shiftedBytes[i] = (byte)(inputBytes[i] << numBitstoShiftBy | (inputBytes[i + 1] & BitBufferHelper.getMSBMask(numEndRestBits)) >> 8 - numEndRestBits);
                    }
                }
                shiftedBytes[i] = (byte)(inputBytes[i] << numBitstoShiftBy | (inputBytes[i + 1] & BitBufferHelper.getMSBMask(numBitstoShiftBy)) >> 8 - numBitstoShiftBy);
            }
        }
        return shiftedBytes;
    }

    public static byte[] shiftBitsToLSB(byte[] inputBytes, int numBits) {
        int numBytes = inputBytes.length;
        int numBitstoShift = numBits % 8;
        byte[] shiftedBytes = new byte[numBytes];
        int inputLsb = 0;
        int inputMsb = 0;
        if (numBitstoShift == 0) {
            return inputBytes;
        }
        for (int i = 1; i < numBytes; ++i) {
            inputLsb = inputBytes[i - 1] & BitBufferHelper.getLSBMask(8 - numBitstoShift);
            inputLsb = inputLsb < 0 ? inputLsb + 256 : inputLsb;
            inputMsb = inputBytes[i] & BitBufferHelper.getMSBMask(numBitstoShift);
            inputMsb = inputBytes[i] < 0 ? inputBytes[i] + 256 : inputBytes[i];
            shiftedBytes[i] = (byte)(inputLsb << numBitstoShift | inputMsb >> 8 - numBitstoShift);
        }
        inputMsb = inputBytes[0] & BitBufferHelper.getMSBMask(numBitstoShift);
        inputMsb = inputMsb < 0 ? inputMsb + 256 : inputMsb;
        shiftedBytes[0] = (byte)(inputMsb >> 8 - numBitstoShift);
        return shiftedBytes;
    }

    public static void insertBits(byte[] data, byte[] inputdataLSB, int startOffset, int numBits) {
        byte[] inputdata = BitBufferHelper.shiftBitsToMSB(inputdataLSB, numBits);
        int numBytes = numBits / 8;
        int startByteOffset = startOffset / 8;
        int extraOffsetBits = startOffset % 8;
        int extranumBits = numBits % 8;
        int RestBits = numBits % 8;
        int InputMSBbits = 0;
        int InputLSBbits = 0;
        if (numBits == 0) {
            return;
        }
        if (extraOffsetBits == 0) {
            if (extranumBits == 0) {
                numBytes = numBits / 8;
                System.arraycopy(inputdata, 0, data, startByteOffset, numBytes);
            } else {
                System.arraycopy(inputdata, 0, data, startByteOffset, numBytes);
                data[startByteOffset + numBytes] = (byte)(data[startByteOffset + numBytes] | inputdata[numBytes] & BitBufferHelper.getMSBMask(extranumBits));
            }
        } else {
            int i;
            for (i = 0; i < numBytes; ++i) {
                if (i != 0) {
                    InputLSBbits = inputdata[i - 1] & BitBufferHelper.getLSBMask(extraOffsetBits);
                }
                InputMSBbits = (InputMSBbits = (int)(inputdata[i] & BitBufferHelper.getMSBMask(8 - extraOffsetBits))) >= 0 ? InputMSBbits : InputMSBbits + 256;
                data[startByteOffset + i] = (byte)(data[startByteOffset + i] | InputLSBbits << 8 - extraOffsetBits | InputMSBbits >> extraOffsetBits);
                InputLSBbits = 0;
                InputMSBbits = 0;
            }
            if (RestBits < 8 - extraOffsetBits) {
                if (numBytes != 0) {
                    InputLSBbits = inputdata[i - 1] & BitBufferHelper.getLSBMask(extraOffsetBits);
                }
                InputMSBbits = (InputMSBbits = (byte)(inputdata[i] & BitBufferHelper.getMSBMask(RestBits))) >= 0 ? InputMSBbits : InputMSBbits + 256;
                data[startByteOffset + i] = (byte)(data[startByteOffset + i] | InputLSBbits << 8 - extraOffsetBits | InputMSBbits >> extraOffsetBits);
            } else if (RestBits == 8 - extraOffsetBits) {
                if (numBytes != 0) {
                    InputLSBbits = inputdata[i - 1] & BitBufferHelper.getLSBMask(extraOffsetBits);
                }
                InputMSBbits = (InputMSBbits = (int)((byte)(inputdata[i] & BitBufferHelper.getMSBMask(8 - extraOffsetBits)))) >= 0 ? InputMSBbits : InputMSBbits + 256;
                data[startByteOffset + i] = (byte)(data[startByteOffset + i] | InputLSBbits << 8 - extraOffsetBits | InputMSBbits >> extraOffsetBits);
            } else {
                if (numBytes != 0) {
                    InputLSBbits = inputdata[i - 1] & BitBufferHelper.getLSBMask(extraOffsetBits);
                }
                InputMSBbits = (InputMSBbits = (int)((byte)(inputdata[i] & BitBufferHelper.getMSBMask(8 - extraOffsetBits)))) >= 0 ? InputMSBbits : InputMSBbits + 256;
                data[startByteOffset + i] = (byte)(data[startByteOffset + i] | InputLSBbits << 8 - extraOffsetBits | InputMSBbits >> extraOffsetBits);
                InputLSBbits = inputdata[i] & BitBufferHelper.getLSBMask(RestBits - (8 - extraOffsetBits)) << 8 - RestBits;
                data[startByteOffset + i + 1] = (byte)(data[startByteOffset + i + 1] | InputLSBbits << 8 - extraOffsetBits);
            }
        }
    }

    public static void checkExceptions(byte[] data, int startOffset, int numBits) throws BufferException {
        int endOffsetByte = startOffset / 8 + numBits / 8 + (numBits % 8 != 0 ? 1 : (startOffset % 8 != 0 ? 1 : 0));
        int startByteOffset = startOffset / 8;
        if (data == null) {
            throw new BufferException("data[] is null\n");
        }
        if (startOffset < 0 || startByteOffset >= data.length || endOffsetByte > data.length || numBits < 0 || numBits > 8 * data.length) {
            throw new BufferException("Illegal arguement/out of bound exception - data.length = " + data.length + " startOffset = " + startOffset + " numBits " + numBits);
        }
    }
}

