/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.packet;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.opendaylight.controller.sal.packet.BitBufferHelper;
import org.opendaylight.controller.sal.packet.Packet;

public class ARP
extends Packet {
    private static final String HWTYPE = "HardwareType";
    private static final String PTYPE = "ProtocolType";
    private static final String HWADDRLENGTH = "HardwareAddressLength";
    private static final String PADDRLENGTH = "ProtocolAddressLength";
    private static final String OPCODE = "OpCode";
    private static final String SENDERHWADDR = "SenderHardwareAddress";
    private static final String SENDERPADDR = "SenderProtocolAddress";
    private static final String TARGETHWADDR = "TargetHardwareAddress";
    private static final String TARGETPADDR = "TargetProtocolAddress";
    public static short HW_TYPE_ETHERNET = 1;
    public static short REQUEST = 1;
    public static short REPLY = (short)2;
    public static short PROTO_TYPE_IP = (short)2048;
    private static Map<String, Pair<Integer, Integer>> fieldCoordinates = new LinkedHashMap<String, Pair<Integer, Integer>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(ARP.HWTYPE, new ImmutablePair((Object)0, (Object)16));
            this.put(ARP.PTYPE, new ImmutablePair((Object)16, (Object)16));
            this.put(ARP.HWADDRLENGTH, new ImmutablePair((Object)32, (Object)8));
            this.put(ARP.PADDRLENGTH, new ImmutablePair((Object)40, (Object)8));
            this.put(ARP.OPCODE, new ImmutablePair((Object)48, (Object)16));
            this.put(ARP.SENDERHWADDR, new ImmutablePair((Object)64, (Object)48));
            this.put(ARP.SENDERPADDR, new ImmutablePair((Object)112, (Object)32));
            this.put(ARP.TARGETHWADDR, new ImmutablePair((Object)144, (Object)48));
            this.put(ARP.TARGETPADDR, new ImmutablePair((Object)192, (Object)32));
        }
    };
    private Map<String, byte[]> fieldValues = new HashMap<String, byte[]>();

    public ARP() {
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public ARP(boolean writeAccess) {
        super(writeAccess);
        this.hdrFieldCoordMap = fieldCoordinates;
        this.hdrFieldsMap = this.fieldValues;
    }

    public short getHardwareType() {
        return BitBufferHelper.getShort(this.fieldValues.get(HWTYPE));
    }

    public short getProtocolType() {
        return BitBufferHelper.getShort(this.fieldValues.get(PTYPE));
    }

    public byte getHardwareAddressLength() {
        return BitBufferHelper.getByte(this.fieldValues.get(HWADDRLENGTH));
    }

    public byte getProtocolAddressLength() {
        return BitBufferHelper.getByte(this.fieldValues.get(PADDRLENGTH));
    }

    public short getOpCode() {
        return BitBufferHelper.getShort(this.fieldValues.get(OPCODE));
    }

    public byte[] getSenderHardwareAddress() {
        return this.fieldValues.get(SENDERHWADDR);
    }

    public byte[] getSenderProtocolAddress() {
        return this.fieldValues.get(SENDERPADDR);
    }

    public byte[] getTargetHardwareAddress() {
        return this.fieldValues.get(TARGETHWADDR);
    }

    public ARP setHardwareType(short hardwareType) {
        byte[] hwType = BitBufferHelper.toByteArray(hardwareType);
        this.fieldValues.put(HWTYPE, hwType);
        return this;
    }

    public ARP setProtocolType(short protocolType) {
        byte[] protType = BitBufferHelper.toByteArray(protocolType);
        this.fieldValues.put(PTYPE, protType);
        return this;
    }

    public ARP setHardwareAddressLength(byte hardwareAddressLength) {
        byte[] hwAddressLength = BitBufferHelper.toByteArray(hardwareAddressLength);
        this.fieldValues.put(HWADDRLENGTH, hwAddressLength);
        return this;
    }

    public ARP setProtocolAddressLength(byte protocolAddressLength) {
        byte[] protocolAddrLength = BitBufferHelper.toByteArray(protocolAddressLength);
        this.fieldValues.put(PADDRLENGTH, protocolAddrLength);
        return this;
    }

    public ARP setOpCode(short opCode) {
        byte[] operationCode = BitBufferHelper.toByteArray(opCode);
        this.fieldValues.put(OPCODE, operationCode);
        return this;
    }

    public ARP setSenderHardwareAddress(byte[] senderHardwareAddress) {
        this.fieldValues.put(SENDERHWADDR, senderHardwareAddress);
        return this;
    }

    public ARP setTargetHardwareAddress(byte[] targetHardwareAddress) {
        this.fieldValues.put(TARGETHWADDR, targetHardwareAddress);
        return this;
    }

    public ARP setTargetProtocolAddress(byte[] targetProtocolAddress) {
        this.fieldValues.put(TARGETPADDR, targetProtocolAddress);
        return this;
    }

    public ARP setSenderProtocolAddress(byte[] senderIP) {
        this.fieldValues.put(SENDERPADDR, senderIP);
        return this;
    }

    public byte[] getTargetProtocolAddress() {
        return this.fieldValues.get(TARGETPADDR);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fieldValues == null ? 0 : this.fieldValues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ARP other = (ARP)obj;
        return !(this.fieldValues == null ? other.fieldValues != null : !this.fieldValues.equals(other.fieldValues));
    }
}

