/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.match;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Arrays;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NetUtils;

public enum MatchType {
    IN_PORT("inPort", 1, NodeConnector.class, 1L, 0L),
    DL_SRC("dlSrc", 2, Byte[].class, 0L, 0xFFFFFFFFFFFFL),
    DL_DST("dlDst", 4, Byte[].class, 0L, 0xFFFFFFFFFFFFL),
    DL_VLAN("dlVlan", 8, Short.class, 0L, 4095L),
    DL_VLAN_PR("dlVlanPriority", 16, Byte.class, 0L, 7L),
    DL_OUTER_VLAN("dlOuterVlan", 32, Short.class, 1L, 4095L),
    DL_OUTER_VLAN_PR("dlOuterVlanPriority", 64, Short.class, 0L, 7L),
    DL_TYPE("dlType", 128, Short.class, 0L, 65535L),
    NW_TOS("nwTOS", 256, Byte.class, 0L, 63L),
    NW_PROTO("nwProto", 512, Byte.class, 0L, 255L),
    NW_SRC("nwSrc", 1024, InetAddress.class, 0L, 0L),
    NW_DST("nwDst", 2048, InetAddress.class, 0L, 0L),
    TP_SRC("tpSrc", 4096, Short.class, 0L, 65535L),
    TP_DST("tpDst", 8192, Short.class, 0L, 65535L);

    public static final short DL_VLAN_NONE = 0;
    private String id;
    private int index;
    private Class<?> dataType;
    private long minValue;
    private long maxValue;

    private MatchType(String id, int index, Class<?> dataType, long minValue, long maxValue) {
        this.id = id;
        this.index = index;
        this.dataType = dataType;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String id() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> dataType() {
        return this.dataType;
    }

    public String getRange() {
        return "[0x" + Long.toHexString(this.minValue) + "-0x" + Long.toHexString(this.maxValue) + "]";
    }

    public boolean isCongruentType(Object value, Object mask) {
        if (mask != null && mask.getClass() != value.getClass()) {
            return false;
        }
        Class<?> e = this.dataType();
        Class<?> g = value.getClass();
        if (g.equals(e)) {
            return true;
        }
        if (e == Short.class) {
            return g.equals(Short.TYPE);
        }
        if (e == Integer.class) {
            return g.equals(Integer.TYPE);
        }
        if (e == Byte.class) {
            return g.equals(Byte.TYPE);
        }
        if (e == Byte[].class) {
            return g.equals(byte[].class);
        }
        if (e == InetAddress.class) {
            return g.getSuperclass().equals(InetAddress.class);
        }
        return false;
    }

    public boolean isValid(Object value, Object mask) {
        if (mask != null && mask.getClass() != value.getClass()) {
            return false;
        }
        if (this.dataType == InetAddress.class) {
            return true;
        }
        if (this.dataType() == Byte[].class) {
            return true;
        }
        if (this.dataType() == NodeConnector.class) {
            return true;
        }
        int val = 0;
        int msk = 0;
        if (value.getClass() == Integer.class || value.getClass() == Integer.TYPE) {
            val = (Integer)value;
            msk = mask != null ? (Integer)mask : 0;
        } else if (value.getClass() == Short.class || value.getClass() == Short.TYPE) {
            val = ((Short)value).intValue() & 0xFFFF;
            msk = mask != null ? ((Short)mask).intValue() & 0xFFFF : 0;
        } else if (value.getClass() == Byte.class || value.getClass() == Byte.TYPE) {
            val = ((Byte)value).intValue() & 0xFF;
            msk = mask != null ? ((Byte)mask).intValue() & 0xFF : 0;
        }
        return (long)val >= this.minValue && (long)val <= this.maxValue && (mask == null || (long)msk >= this.minValue && (long)msk <= this.maxValue);
    }

    public long getBitMask(Object mask) {
        if (this.dataType == InetAddress.class) {
            return 0L;
        }
        if (this.dataType() == Byte[].class) {
            if (mask == null) {
                return 0xFFFFFFFFFFFFL;
            }
            byte[] mac = (byte[])mask;
            long bitmask = 0L;
            for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
                bitmask |= ((long)mac[i] & 0xFFL) << (5 - i) * 8;
            }
            return bitmask;
        }
        if (this.dataType == Integer.class || this.dataType == Integer.TYPE) {
            return mask == null ? this.maxValue : ((Integer)mask).longValue();
        }
        if (this.dataType == Short.class || this.dataType == Short.TYPE) {
            return mask == null ? this.maxValue : ((Short)mask).longValue();
        }
        if (this.dataType == Byte.class || this.dataType == Byte.TYPE) {
            return mask == null ? this.maxValue : ((Byte)mask).longValue();
        }
        return 0L;
    }

    public String stringify(Object value) {
        if (value == null) {
            return null;
        }
        switch (this) {
            case DL_DST: 
            case DL_SRC: {
                return HexEncode.bytesToHexStringFormat((byte[])value);
            }
            case DL_TYPE: 
            case DL_VLAN: {
                return Integer.valueOf(NetUtils.getUnsignedShort((Short)value)).toString();
            }
            case NW_SRC: 
            case NW_DST: {
                return ((InetAddress)value).getHostAddress();
            }
            case NW_TOS: {
                return Integer.valueOf(NetUtils.getUnsignedByte((Byte)value)).toString();
            }
            case TP_SRC: 
            case TP_DST: {
                return Integer.valueOf(NetUtils.getUnsignedShort((Short)value)).toString();
            }
        }
        return value.toString();
    }

    public int valueHashCode(Object o) {
        if (o == null) {
            return 0;
        }
        switch (this) {
            case DL_DST: 
            case DL_SRC: {
                return NetUtils.byteArray4ToInt((byte[])o);
            }
        }
        return o.hashCode();
    }

    public int hashCode(Object v, Object m) {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.calculateConsistentHashCode();
        switch (this) {
            case DL_DST: 
            case DL_SRC: {
                result = 31 * result + (v == null ? 0 : NetUtils.byteArray4ToInt((byte[])v));
                result = 31 * result + (m == null ? 0 : NetUtils.byteArray4ToInt((byte[])m));
                break;
            }
            case NW_SRC: 
            case NW_DST: {
                InetAddress ip = (InetAddress)v;
                int maskLen = m == null ? (ip instanceof Inet4Address ? 32 : 128) : NetUtils.getSubnetMaskLength((InetAddress)m);
                InetAddress prefix = NetUtils.getSubnetPrefix(ip, maskLen);
                result = 31 * result + (v == null ? 0 : prefix.hashCode());
                break;
            }
            default: {
                result = 31 * result + (v == null ? 0 : v.hashCode());
                result = 31 * result + (m == null ? 0 : m.hashCode());
            }
        }
        return result;
    }

    public boolean equalValues(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        switch (this) {
            case DL_DST: 
            case DL_SRC: {
                return Arrays.equals((byte[])a, (byte[])b);
            }
        }
        return a.equals(b);
    }

    public boolean equalMasks(Object a, Object b) {
        if (a == b) {
            return true;
        }
        switch (this) {
            case NW_SRC: 
            case NW_DST: {
                if (a != null && b != null) break;
                InetAddress mask = a == null ? (InetAddress)b : (InetAddress)a;
                int maxLength = mask instanceof Inet4Address ? 32 : 128;
                return NetUtils.getSubnetMaskLength(mask) == maxLength;
            }
        }
        if (a == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object value1, Object value2, Object mask1, Object mask2) {
        switch (this) {
            case NW_SRC: 
            case NW_DST: {
                InetAddress thisIP = (InetAddress)value1;
                int thisMaskLen = mask1 == null ? (thisIP instanceof Inet4Address ? 32 : 128) : NetUtils.getSubnetMaskLength((InetAddress)mask1);
                InetAddress otherIP = (InetAddress)value2;
                int otherMaskLen = mask2 == null ? (otherIP instanceof Inet4Address ? 32 : 128) : NetUtils.getSubnetMaskLength((InetAddress)mask2);
                return NetUtils.getSubnetPrefix(thisIP, thisMaskLen).equals(NetUtils.getSubnetPrefix(otherIP, otherMaskLen));
            }
        }
        return this.equalValues(value1, value2) && this.equalMasks(mask1, mask2);
    }

    public int calculateConsistentHashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return 0;
    }
}

