/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.match;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.match.MatchType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class MatchField
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MatchField.class);
    private MatchType type;
    private Object value;
    private Object mask;
    private boolean isValid;

    private MatchField() {
    }

    public MatchField(MatchType type, Object value, Object mask) {
        this.type = type;
        this.value = value;
        this.mask = mask;
        this.isValid = this.checkValueType() && this.checkValues();
    }

    public MatchField(MatchType type, Object value) {
        this.type = type;
        this.value = value;
        this.mask = null;
        this.isValid = this.checkValueType() && this.checkValues();
    }

    public Object getValue() {
        return this.value;
    }

    @XmlElement(name="value")
    private String getValueString() {
        return this.type.stringify(this.value);
    }

    public MatchType getType() {
        return this.type;
    }

    @XmlElement(name="type")
    private String getTypeString() {
        return this.type.toString();
    }

    public Object getMask() {
        return this.mask;
    }

    @XmlElement(name="mask")
    private String getMaskString() {
        return this.type.stringify(this.mask);
    }

    public long getBitMask() {
        return this.type.getBitMask(this.mask);
    }

    public boolean isValid() {
        return this.isValid;
    }

    private boolean checkValueType() {
        if (!this.type.isCongruentType(this.value, this.mask)) {
            String valueClass = this.value == null ? "null" : this.value.getClass().getSimpleName();
            String maskClass = this.mask == null ? "null" : this.mask.getClass().getSimpleName();
            String error = "Invalid match field's value or mask types.For field: " + this.type.id() + " Expected:" + this.type.dataType().getSimpleName() + " or equivalent," + " Got:(" + valueClass + "," + maskClass + ")";
            MatchField.throwException(error);
            return false;
        }
        return true;
    }

    private boolean checkValues() {
        if (!this.type.isValid(this.value, this.mask)) {
            String maskString = this.mask == null ? "null" : "0x" + Integer.toHexString(Integer.parseInt(this.mask.toString()));
            String error = "Invalid match field's value or mask assignement.For field: " + this.type.id() + " Expected: " + this.type.getRange() + ", Got:(0x" + Integer.toHexString(Integer.parseInt(this.value.toString())) + "," + maskString + ")";
            MatchField.throwException(error);
            return false;
        }
        return true;
    }

    private static void throwException(String error) {
        try {
            throw new Exception(error);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return;
        }
    }

    public MatchField clone() {
        MatchField cloned = null;
        try {
            cloned = (MatchField)super.clone();
            if (this.value instanceof byte[]) {
                cloned.value = ((byte[])this.value).clone();
                if (this.mask != null) {
                    cloned.mask = ((byte[])this.mask).clone();
                }
            }
            cloned.type = this.type;
            cloned.isValid = this.isValid;
        }
        catch (CloneNotSupportedException e) {
            logger.error("", (Throwable)e);
        }
        return cloned;
    }

    public String toString() {
        return this.mask == null ? String.format("%s(%s)", this.getTypeString(), this.getValueString()) : String.format("%s(%s,%s)", this.getTypeString(), this.getValueString(), this.getMaskString());
    }

    public int hashCode() {
        return this.type.hashCode(this.value, this.mask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchField other = (MatchField)obj;
        if (this.type != other.type) {
            return false;
        }
        return this.type.equals(this.value, other.value, this.mask, other.mask);
    }
}

