/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.match;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.match.MatchField;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NetUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Match
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<MatchType, MatchType> reversableMatches;
    private Map<MatchType, MatchField> fields;
    private int matches;

    public Match() {
        this.fields = new HashMap<MatchType, MatchField>();
        this.matches = 0;
    }

    public Match(Match match) {
        this.fields = new HashMap<MatchType, MatchField>(match.fields);
        this.matches = match.matches;
    }

    public void setField(MatchType type, Object value, Object mask) {
        MatchField field = new MatchField(type, value, mask);
        if (field.isValid()) {
            this.fields.put(type, field);
            this.matches |= type.getIndex();
        }
    }

    public void setField(MatchType type, Object value) {
        MatchField field = new MatchField(type, value);
        if (field.isValid()) {
            this.fields.put(type, field);
            this.matches |= type.getIndex();
        }
    }

    public void setField(MatchField field) {
        if (field.isValid()) {
            this.fields.put(field.getType(), field);
            this.matches |= field.getType().getIndex();
        }
    }

    public void clearField(MatchType type) {
        this.fields.remove((Object)type);
        this.matches &= ~type.getIndex();
    }

    public MatchField getField(MatchType type) {
        return this.fields.get((Object)type);
    }

    public int getMatches() {
        return this.matches;
    }

    public List<MatchType> getMatchesList() {
        return new ArrayList<MatchType>(this.fields.keySet());
    }

    @XmlElement(name="matchField")
    public List<MatchField> getMatchFields() {
        return new ArrayList<MatchField>(this.fields.values());
    }

    public boolean isIPv6() {
        return this.isPresent(MatchType.DL_TYPE) && ((Short)this.getField(MatchType.DL_TYPE).getValue()).equals(EtherTypes.IPv6.shortValue()) || this.isPresent(MatchType.NW_PROTO) && ((Byte)this.getField(MatchType.NW_PROTO).getValue()).equals(IPProtocols.IPV6ICMP.byteValue()) || this.isPresent(MatchType.NW_SRC) && this.getField(MatchType.NW_SRC).getValue() instanceof Inet6Address || this.isPresent(MatchType.NW_DST) && this.getField(MatchType.NW_DST).getValue() instanceof Inet6Address;
    }

    public boolean isIPv4() {
        return !this.isIPv6();
    }

    public boolean isAny(MatchType type) {
        return !this.fields.containsKey((Object)type);
    }

    public boolean isPresent(MatchType type) {
        return this.fields.get((Object)type) != null;
    }

    public Match clone() {
        Match cloned = null;
        try {
            cloned = (Match)super.clone();
            cloned.matches = this.matches;
            cloned.fields = new HashMap<MatchType, MatchField>();
            for (Map.Entry<MatchType, MatchField> entry : this.fields.entrySet()) {
                cloned.fields.put(entry.getKey(), entry.getValue().clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return cloned;
    }

    public Match reverse() {
        Match reverse = this.clone();
        for (Map.Entry<MatchType, MatchType> entry : reversableMatches.entrySet()) {
            MatchType from = entry.getKey();
            MatchType to = entry.getValue();
            if (!this.isPresent(from)) continue;
            reverse.setField(to, this.getField(from).getValue(), this.getField(from).getMask());
            if (this.isPresent(to)) continue;
            reverse.clearField(from);
        }
        reverse.clearField(MatchType.IN_PORT);
        return reverse;
    }

    public boolean conflictWithFilter(Match filter) {
        return !this.intersetcs(filter);
    }

    public Match mergeWithFilter(Match filter) {
        return this.getIntersection(filter);
    }

    public Match getIntersection(Match other) {
        if (!this.intersetcs(other)) {
            return null;
        }
        if (this.getMatches() == 0) {
            return other.clone();
        }
        if (other.getMatches() == 0) {
            return this.clone();
        }
        Match intersection = new Match();
        block3: for (MatchType type : MatchType.values()) {
            if (this.isAny(type) && other.isAny(type)) continue;
            if (this.isAny(type)) {
                intersection.setField(other.getField(type).clone());
                continue;
            }
            if (other.isAny(type)) {
                intersection.setField(this.getField(type).clone());
                continue;
            }
            switch (type) {
                case NW_SRC: 
                case NW_DST: {
                    int otherMaskLen;
                    int thisMaskLen;
                    MatchField thisField = this.getField(type);
                    MatchField otherField = other.getField(type);
                    InetAddress thisAddress = (InetAddress)thisField.getValue();
                    InetAddress otherAddress = (InetAddress)otherField.getValue();
                    InetAddress thisMask = (InetAddress)thisField.getMask();
                    InetAddress otherMask = (InetAddress)otherField.getMask();
                    int n = thisMask == null ? (thisAddress instanceof Inet4Address ? 32 : 128) : (thisMaskLen = NetUtils.getSubnetMaskLength(thisMask));
                    int n2 = otherMask == null ? (otherAddress instanceof Inet4Address ? 32 : 128) : (otherMaskLen = NetUtils.getSubnetMaskLength(otherMask));
                    if (thisMaskLen < otherMaskLen) {
                        intersection.setField(new MatchField(type, NetUtils.getSubnetPrefix(otherAddress, otherMaskLen), otherMask));
                        continue block3;
                    }
                    intersection.setField(new MatchField(type, NetUtils.getSubnetPrefix(thisAddress, thisMaskLen), thisMask));
                    continue block3;
                }
                default: {
                    intersection.setField(this.getField(type).clone());
                }
            }
        }
        return intersection;
    }

    public boolean intersetcs(Match other) {
        if (other == null) {
            return false;
        }
        if (this.getMatches() == 0 || other.getMatches() == 0) {
            return true;
        }
        block4: for (MatchType type : MatchType.values()) {
            if (this.isAny(type) || other.isAny(type)) continue;
            MatchField thisField = this.getField(type);
            MatchField otherField = other.getField(type);
            switch (type) {
                case DL_SRC: 
                case DL_DST: {
                    if (Arrays.equals((byte[])thisField.getValue(), (byte[])otherField.getValue())) continue block4;
                    return false;
                }
                case NW_SRC: 
                case NW_DST: {
                    InetAddress otherMask;
                    InetAddress thisAddress = (InetAddress)thisField.getValue();
                    InetAddress otherAddress = (InetAddress)otherField.getValue();
                    if (thisAddress instanceof Inet4Address && otherAddress instanceof Inet6Address || thisAddress instanceof Inet6Address && otherAddress instanceof Inet4Address) {
                        return false;
                    }
                    InetAddress thisMask = (InetAddress)thisField.getMask();
                    if (!NetUtils.inetAddressConflict(thisAddress, otherAddress, thisMask, otherMask = (InetAddress)otherField.getMask()) || !NetUtils.inetAddressConflict(otherAddress, thisAddress, otherMask, thisMask)) continue block4;
                    return false;
                }
                default: {
                    if (thisField.getValue().equals(otherField.getValue())) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.fields == null) {
            result = 31 * result;
        } else {
            TreeMap<MatchType, MatchField> tm = new TreeMap<MatchType, MatchField>(this.fields);
            for (MatchType field : tm.keySet()) {
                MatchField f = tm.get((Object)field);
                int fieldHashCode = (field == null ? 0 : field.calculateConsistentHashCode()) ^ (f == null ? 0 : f.hashCode());
                result = 31 * result + fieldHashCode;
            }
        }
        result = 31 * result + this.matches;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Match other = (Match)obj;
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return this.matches == other.matches;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Match [fields=");
        builder.append(this.fields);
        builder.append(", matches=");
        builder.append(this.matches);
        builder.append("]");
        return builder.toString();
    }

    static {
        HashMap<MatchType, MatchType> map = new HashMap<MatchType, MatchType>();
        map.put(MatchType.DL_SRC, MatchType.DL_DST);
        map.put(MatchType.DL_DST, MatchType.DL_SRC);
        map.put(MatchType.NW_SRC, MatchType.NW_DST);
        map.put(MatchType.NW_DST, MatchType.NW_SRC);
        map.put(MatchType.TP_SRC, MatchType.TP_DST);
        map.put(MatchType.TP_DST, MatchType.TP_SRC);
        reversableMatches = Collections.unmodifiableMap(map);
    }
}

