/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.flowprogrammer;

import java.io.Serializable;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.action.SetDlType;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Flow
implements Cloneable,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(Flow.class);
    private static final long serialVersionUID = 1L;
    @XmlElement
    private Match match;
    @XmlElement
    private List<Action> actions;
    @XmlElement
    private short priority;
    @XmlElement
    private short idleTimeout;
    @XmlElement
    private short hardTimeout;
    @XmlElement
    private long id;

    public Flow() {
        this.match = null;
        this.actions = null;
    }

    public Flow(Match match, List<Action> actions) {
        if (match.isIPv4() && this.actionsAreIPv6()) {
            try {
                throw new Exception("Conflicting Match and Action list");
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        } else {
            this.match = match;
            this.actions = actions;
        }
    }

    public Match getMatch() {
        return this.match.clone();
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public List<Action> getActions() {
        return this.actions == null ? null : new ArrayList<Action>(this.actions);
    }

    public void setActions(List<Action> actions) {
        if (actions == null) {
            return;
        }
        this.actions = new ArrayList<Action>(actions.size());
        for (Action action : actions) {
            if (!action.isValid()) continue;
            this.actions.add(action);
        }
    }

    public boolean isIPv6() {
        return this.match.isIPv6() ? true : this.actionsAreIPv6();
    }

    private boolean actionsAreIPv6() {
        if (this.actions != null) {
            for (Action action : this.actions) {
                switch (action.getType()) {
                    case SET_NW_SRC: {
                        if (!(((SetNwSrc)action).getAddress() instanceof Inet6Address)) break;
                        return true;
                    }
                    case SET_NW_DST: {
                        if (!(((SetNwDst)action).getAddress() instanceof Inet6Address)) break;
                        return true;
                    }
                    case SET_DL_TYPE: {
                        if (((SetDlType)action).getDlType() != EtherTypes.IPv6.intValue()) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Flow clone() {
        Flow cloned = null;
        try {
            cloned = (Flow)super.clone();
            cloned.match = this.getMatch();
            cloned.actions = this.getActions();
        }
        catch (CloneNotSupportedException e) {
            logger.error("", (Throwable)e);
        }
        return cloned;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + this.hardTimeout;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.idleTimeout;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Flow other = (Flow)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        return this.priority == other.priority;
    }

    public String toString() {
        return "Flow[match = " + this.match + ", actions = " + this.actions + ", priority = " + this.priority + ", id = " + this.id + ", idleTimeout = " + this.idleTimeout + ", hardTimeout = " + this.hardTimeout + "]";
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public short getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public short getHardTimeout() {
        return this.hardTimeout;
    }

    public void setHardTimeout(short hardTimeout) {
        this.hardTimeout = hardTimeout;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean addAction(Action action) {
        if (action == null || !action.isValid()) {
            return false;
        }
        return this.actions.add(action);
    }

    public boolean removeAction(Action action) {
        if (action == null) {
            return false;
        }
        return this.actions.remove(action);
    }

    public boolean removeAction(ActionType actionType) {
        for (Action action : this.getActions()) {
            if (action.getType() != actionType || this.removeAction(action)) continue;
            return false;
        }
        return true;
    }
}

