/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TimeStamp
extends Property {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    private long timestamp;
    @XmlElement(name="name")
    private String timestampName;
    public static final String TimeStampPropName = "timeStamp";

    public TimeStamp(long timestamp, String timestampName) {
        super(TimeStampPropName);
        this.timestamp = timestamp;
        this.timestampName = timestampName;
    }

    private TimeStamp() {
        super(TimeStampPropName);
        this.timestamp = 0L;
        this.timestampName = null;
    }

    @Override
    public TimeStamp clone() {
        return new TimeStamp(this.timestamp, this.timestampName);
    }

    public long getValue() {
        return this.timestamp;
    }

    public String getTimeStampName() {
        return this.timestampName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.timestampName == null ? 0 : this.timestampName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeStamp other = (TimeStamp)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return !(this.timestampName == null ? other.timestampName != null : !this.timestampName.equals(other.timestampName));
    }

    @Override
    public String toString() {
        return "TimeStamp[" + this.timestampName + ": " + this.timestamp + "]";
    }

    @Override
    public String getStringValue() {
        return this.timestampName + ": " + new Date(this.timestamp);
    }
}

