/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class State
extends Property {
    @XmlElement(name="value")
    private short stateValue;
    public static final short EDGE_DOWN = 0;
    public static final short EDGE_UP = 1;
    public static final short EDGE_UNK = Short.MAX_VALUE;
    public static final String StatePropName = "state";

    private State() {
        super(StatePropName);
        this.stateValue = Short.MAX_VALUE;
    }

    public State(short state) {
        super(StatePropName);
        this.stateValue = state;
    }

    @Override
    public State clone() {
        return new State(this.stateValue);
    }

    public short getValue() {
        return this.stateValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.stateValue;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        State other = (State)obj;
        return this.stateValue == other.stateValue;
    }

    @Override
    public String toString() {
        return "State[" + this.stateValue + "]";
    }

    @Override
    public String getStringValue() {
        if (this.stateValue == 0) {
            return "EDGE_DOWN";
        }
        if (this.stateValue == 1) {
            return "EDGE_UP";
        }
        if (this.stateValue == Short.MAX_VALUE) {
            return "EDGE_UNK";
        }
        return String.valueOf(this.stateValue);
    }
}

