/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private List<Edge> edges;

    private Path() {
        this.edges = null;
    }

    public Path(List<Edge> edges) throws ConstructionException {
        boolean sequential = true;
        if (edges.size() >= 2) {
            for (int i = 0; i < edges.size() - 1; ++i) {
                Edge current = edges.get(i);
                Edge next = edges.get(i + 1);
                if (current.getHeadNodeConnector().getNode().equals(next.getTailNodeConnector().getNode())) continue;
                sequential = false;
            }
        } else if (edges.size() == 0) {
            throw new ConstructionException("Path is empty");
        }
        if (!sequential) {
            throw new ConstructionException("Path is not sequential");
        }
        this.edges = edges;
    }

    public Path(Path src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("src supplied was null");
        }
        this.edges = new LinkedList<Edge>(src.getEdges());
    }

    public Node getStartNode() {
        return this.edges.get(0).getTailNodeConnector().getNode();
    }

    public Node getEndNode() {
        return this.edges.get(this.edges.size() - 1).getHeadNodeConnector().getNode();
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return !(this.edges == null ? other.edges != null : !this.edges.equals(other.edges));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.edges.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.edges.get(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

