/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NodeTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Short SPECIALNODETABLEID = 0;
    private Object nodeTableID;
    private String nodeTableType;
    @XmlElement(name="node")
    private Node nodeTableNode;
    private String nodeTableIDString;

    private NodeTable() {
        this.nodeTableIDString = null;
        this.nodeTableID = null;
        this.nodeTableType = null;
        this.nodeTableNode = null;
    }

    public NodeTable(String nodeTableType, Object id, Node node) throws ConstructionException {
        if (NodeTableIDType.getClassType(nodeTableType) == null || !NodeTableIDType.getClassType(nodeTableType).isInstance(id) || !node.getType().equals(nodeTableType)) {
            throw new ConstructionException("Type of incoming object:" + id.getClass() + " not compatible with expected type:" + NodeTableIDType.getClassType(nodeTableType) + " or Node type incompatible:" + node.getType());
        }
        this.nodeTableType = nodeTableType;
        this.nodeTableID = id;
        this.nodeTableNode = node;
    }

    public NodeTable(NodeTable src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("Null incoming object to copy from");
        }
        this.nodeTableType = src.getType();
        this.nodeTableID = src.getID();
        this.nodeTableNode = new Node(src.getNode());
    }

    public Object getID() {
        return this.nodeTableID;
    }

    public String getType() {
        return this.nodeTableType;
    }

    private void setType(String type) {
        this.nodeTableType = type;
        if (this.nodeTableIDString != null) {
            this.fillmeFromString(type, this.nodeTableIDString);
        }
    }

    public Node getNode() {
        return this.nodeTableNode;
    }

    public void setNodeTableNode(Node nodeTableNode) {
        this.nodeTableNode = nodeTableNode;
    }

    @XmlElement(name="id")
    public String getNodeTableIDString() {
        return this.nodeTableIDString != null ? this.nodeTableIDString : this.nodeTableID.toString();
    }

    private void setNodeTableIDString(String IDStr) {
        this.nodeTableIDString = IDStr;
        if (this.nodeTableType != null) {
            this.fillmeFromString(this.nodeTableType, IDStr);
        }
    }

    private void fillmeFromString(String typeStr, String IDStr) {
        if (typeStr == null) {
            return;
        }
        if (IDStr == null) {
            return;
        }
        this.nodeTableType = typeStr;
        this.nodeTableID = Byte.parseByte(IDStr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeTableID == null ? 0 : this.nodeTableID.hashCode());
        result = 31 * result + (this.nodeTableNode == null ? 0 : this.nodeTableNode.hashCode());
        result = 31 * result + (this.nodeTableType == null ? 0 : this.nodeTableType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeTable other = (NodeTable)obj;
        if (this.nodeTableID == null ? other.nodeTableID != null : !this.nodeTableID.equals(other.nodeTableID)) {
            return false;
        }
        if (this.nodeTableNode == null ? other.nodeTableNode != null : !this.nodeTableNode.equals(other.nodeTableNode)) {
            return false;
        }
        return !(this.nodeTableType == null ? other.nodeTableType != null : !this.nodeTableType.equals(other.nodeTableType));
    }

    public String toString() {
        return this.getNodeTableIdAsString() + "@" + this.nodeTableNode;
    }

    public String getNodeTableIdAsString() {
        return this.nodeTableType + "|" + this.nodeTableID.toString();
    }

    public static final class NodeTableIDType {
        private static final ConcurrentHashMap<String, Class<? extends Object>> compatibleType = new ConcurrentHashMap();
        public static String OPENFLOW = "OF";
        public static String PCEP = "PE";
        public static String ONEPK = "PK";
        public static String PRODUCTION = "PR";

        public static Class<?> getClassType(String type) {
            return compatibleType.get(type);
        }

        public static Set<String> values() {
            return compatibleType.keySet();
        }

        public static boolean registerIDType(String type, Class<? extends Object> compatibleID) {
            if (compatibleType.get(type) != null) {
                return false;
            }
            compatibleType.put(type, compatibleID);
            return true;
        }

        public static void unRegisterIDType(String type) {
            compatibleType.remove(type);
        }

        static {
            compatibleType.put(OPENFLOW, Byte.class);
            compatibleType.put(PCEP, UUID.class);
            compatibleType.put(ONEPK, String.class);
            compatibleType.put(PRODUCTION, String.class);
        }
    }
}

