/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.INodeConnectorFactory;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class NodeConnector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Short SPECIALNODECONNECTORID = 0;
    private Object nodeConnectorID;
    private String nodeConnectorType;
    @XmlElement(name="node")
    private Node nodeConnectorNode;
    private String nodeConnectorIDString;

    private NodeConnector() {
        this.nodeConnectorIDString = null;
        this.nodeConnectorID = null;
        this.nodeConnectorType = null;
        this.nodeConnectorNode = null;
    }

    public NodeConnector(String nodeConnectorType, Object id, Node node) throws ConstructionException {
        String compatibleNode = NodeConnectorIDType.getCompatibleNode(nodeConnectorType);
        if (NodeConnectorIDType.getClassType(nodeConnectorType) == null || !NodeConnectorIDType.getClassType(nodeConnectorType).isInstance(id) || compatibleNode != null && !node.getType().equals(compatibleNode)) {
            throw new ConstructionException("Type of incoming object:" + id.getClass() + " not compatible with expected type:" + NodeConnectorIDType.getClassType(nodeConnectorType) + " or Node type incompatible:" + node.getType());
        }
        this.nodeConnectorType = nodeConnectorType;
        this.nodeConnectorID = id;
        this.nodeConnectorNode = node;
    }

    public NodeConnector(NodeConnector src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("Null incoming object to copy from");
        }
        this.nodeConnectorType = src.getType();
        this.nodeConnectorID = src.getID();
        this.nodeConnectorNode = new Node(src.getNode());
    }

    @XmlElement(name="type")
    public String getType() {
        return this.nodeConnectorType;
    }

    private void fillmeFromString(String typeStr, String IDStr) {
        if (typeStr == null) {
            return;
        }
        if (IDStr == null) {
            return;
        }
        this.nodeConnectorType = typeStr;
        if (typeStr.equals(NodeConnectorIDType.OPENFLOW) || typeStr.equals(NodeConnectorIDType.OPENFLOW2ONEPK) || typeStr.equals(NodeConnectorIDType.OPENFLOW2PCEP)) {
            try {
                Short ID = Short.parseShort(IDStr);
                this.nodeConnectorID = ID;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (typeStr.equals(NodeConnectorIDType.ONEPK) || typeStr.equals(NodeConnectorIDType.ONEPK2OPENFLOW) || typeStr.equals(NodeConnectorIDType.ONEPK2PCEP) || typeStr.equals(NodeConnectorIDType.PRODUCTION)) {
            try {
                this.nodeConnectorID = IDStr;
            }
            catch (Exception ex) {
                return;
            }
        }
        if (typeStr.equals(NodeConnectorIDType.PCEP) || typeStr.equals(NodeConnectorIDType.PCEP2ONEPK) || typeStr.equals(NodeConnectorIDType.PCEP2OPENFLOW)) {
            try {
                Integer ID = Integer.parseInt(IDStr);
                this.nodeConnectorID = ID;
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    private void setType(String type) {
        this.nodeConnectorType = type;
        if (this.nodeConnectorIDString != null) {
            this.fillmeFromString(type, this.nodeConnectorIDString);
        }
    }

    public Object getID() {
        return this.nodeConnectorID;
    }

    @XmlElement(name="id")
    public String getNodeConnectorIDString() {
        return this.nodeConnectorID.toString();
    }

    private void setNodeConnectorIDString(String IDStr) {
        this.nodeConnectorIDString = IDStr;
        if (this.nodeConnectorType != null) {
            this.fillmeFromString(this.nodeConnectorType, IDStr);
        }
    }

    public Node getNode() {
        return this.nodeConnectorNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeConnectorID == null ? 0 : this.nodeConnectorID.hashCode());
        result = 31 * result + (this.nodeConnectorNode == null ? 0 : this.nodeConnectorNode.hashCode());
        result = 31 * result + (this.nodeConnectorType == null ? 0 : this.nodeConnectorType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeConnector other = (NodeConnector)obj;
        if (this.nodeConnectorID == null ? other.nodeConnectorID != null : !this.nodeConnectorID.equals(other.nodeConnectorID)) {
            return false;
        }
        if (this.nodeConnectorNode == null ? other.nodeConnectorNode != null : !this.nodeConnectorNode.equals(other.nodeConnectorNode)) {
            return false;
        }
        return !(this.nodeConnectorType == null ? other.nodeConnectorType != null : !this.nodeConnectorType.equals(other.nodeConnectorType));
    }

    public String toString() {
        return this.getNodeConnectorIdAsString() + "@" + this.nodeConnectorNode;
    }

    public String getNodeConnectorIdAsString() {
        if (this.nodeConnectorType.equals(NodeConnectorIDType.CONTROLLER) || this.nodeConnectorType.equals(NodeConnectorIDType.ALL) || this.nodeConnectorType.equals(NodeConnectorIDType.SWSTACK) || this.nodeConnectorType.equals(NodeConnectorIDType.HWPATH)) {
            return this.nodeConnectorType;
        }
        return this.nodeConnectorType + "|" + this.nodeConnectorID.toString();
    }

    public static NodeConnector fromString(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = str.split("\\@");
        if (parts.length != 2) {
            return null;
        }
        Node n = Node.fromString(parts[1]);
        if (n == null) {
            return null;
        }
        return NodeConnector.fromStringNoNode(parts[0], n);
    }

    public static Set<NodeConnector> fromString(Collection<String> stringCollection) {
        HashSet<NodeConnector> set = new HashSet<NodeConnector>();
        if (stringCollection != null) {
            for (String str : stringCollection) {
                NodeConnector nodeConnector = NodeConnector.fromString(str);
                if (nodeConnector == null) continue;
                set.add(nodeConnector);
            }
        }
        return set;
    }

    public static NodeConnector fromStringNoNode(String str, Node n) {
        if (str == null) {
            return null;
        }
        String[] nodeConnectorParts = str.split("\\|");
        if (nodeConnectorParts.length != 2) {
            String numStr = str.toUpperCase();
            Short ofPortID = null;
            try {
                ofPortID = Short.decode(numStr);
            }
            catch (Exception ex) {
                ofPortID = null;
            }
            if (ofPortID == null) {
                try {
                    if (str.equalsIgnoreCase(NodeConnectorIDType.CONTROLLER.toString())) {
                        return new NodeConnector(NodeConnectorIDType.CONTROLLER, SPECIALNODECONNECTORID, n);
                    }
                    if (str.equalsIgnoreCase(NodeConnectorIDType.HWPATH.toString())) {
                        return new NodeConnector(NodeConnectorIDType.HWPATH, SPECIALNODECONNECTORID, n);
                    }
                    if (str.equalsIgnoreCase(NodeConnectorIDType.SWSTACK.toString())) {
                        return new NodeConnector(NodeConnectorIDType.SWSTACK, SPECIALNODECONNECTORID, n);
                    }
                    if (str.equalsIgnoreCase(NodeConnectorIDType.ALL.toString())) {
                        return new NodeConnector(NodeConnectorIDType.ALL, SPECIALNODECONNECTORID, n);
                    }
                }
                catch (ConstructionException ex) {
                    return null;
                }
                return null;
            }
            try {
                return new NodeConnector(NodeConnectorIDType.OPENFLOW, ofPortID, n);
            }
            catch (ConstructionException ex) {
                return null;
            }
        }
        String typeStr = nodeConnectorParts[0];
        String IDStr = nodeConnectorParts[1];
        return NodeConnector.fromStringNoNode(typeStr, IDStr, n);
    }

    public static NodeConnector fromStringNoNode(String typeStr, String IDStr, Node n) {
        if (typeStr == null) {
            return null;
        }
        if (IDStr == null) {
            return null;
        }
        if (typeStr.equals(NodeConnectorIDType.OPENFLOW) || typeStr.equals(NodeConnectorIDType.OPENFLOW2ONEPK) || typeStr.equals(NodeConnectorIDType.OPENFLOW2PCEP)) {
            try {
                Short ID = Short.parseShort(IDStr);
                return new NodeConnector(typeStr, ID, n);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (typeStr.equals(NodeConnectorIDType.ONEPK) || typeStr.equals(NodeConnectorIDType.ONEPK2OPENFLOW) || typeStr.equals(NodeConnectorIDType.ONEPK2PCEP) || typeStr.equals(NodeConnectorIDType.PRODUCTION)) {
            try {
                return new NodeConnector(typeStr, IDStr, n);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (typeStr.equals(NodeConnectorIDType.PCEP) || typeStr.equals(NodeConnectorIDType.PCEP2ONEPK) || typeStr.equals(NodeConnectorIDType.PCEP2OPENFLOW)) {
            try {
                Integer ID = Integer.parseInt(IDStr);
                return new NodeConnector(typeStr, ID, n);
            }
            catch (Exception ex) {
                return null;
            }
        }
        INodeConnectorFactory f = (INodeConnectorFactory)ServiceHelper.getGlobalInstance(INodeConnectorFactory.class, new NodeConnector(), "(protocolName=" + typeStr + ")");
        if (f == null) {
            return null;
        }
        return f.fromStringNoNode(typeStr, IDStr, n);
    }

    public static class NodeConnectorIDType {
        private static final ConcurrentHashMap<String, ImmutablePair<Class<? extends Object>, String>> compatibleType = new ConcurrentHashMap();
        public static String CONTROLLER = "CTRL";
        public static String ALL = "ALL";
        public static String SWSTACK = "SW";
        public static String HWPATH = "HW";
        public static String OPENFLOW = "OF";
        public static String PCEP = "PE";
        public static String ONEPK = "PK";
        public static String OPENFLOW2PCEP = "O2E";
        public static String PCEP2OPENFLOW = "E2O";
        public static String OPENFLOW2ONEPK = "O2K";
        public static String ONEPK2OPENFLOW = "K2O";
        public static String PCEP2ONEPK = "E2K";
        public static String ONEPK2PCEP = "K2E";
        public static String PRODUCTION = "PR";

        public static Class<?> getClassType(String type) {
            if (compatibleType.get(type) == null) {
                return null;
            }
            return (Class)compatibleType.get(type).getLeft();
        }

        public static String getCompatibleNode(String type) {
            if (compatibleType.get(type) == null) {
                return null;
            }
            return (String)compatibleType.get(type).getRight();
        }

        public static boolean registerIDType(String type, Class<? extends Object> compatibleID, String compatibleNode) {
            if (compatibleType.get(type) != null) {
                return false;
            }
            compatibleType.put(type, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(compatibleID, (Object)compatibleNode));
            return true;
        }

        public static void unRegisterIDType(String type) {
            compatibleType.remove(type);
        }

        static {
            compatibleType.put(CONTROLLER, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, null));
            compatibleType.put(ALL, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, null));
            compatibleType.put(SWSTACK, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, null));
            compatibleType.put(HWPATH, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, null));
            compatibleType.put(OPENFLOW, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, (Object)Node.NodeIDType.OPENFLOW));
            compatibleType.put(PCEP, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Integer.class, (Object)Node.NodeIDType.PCEP));
            compatibleType.put(ONEPK, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(String.class, (Object)Node.NodeIDType.ONEPK));
            compatibleType.put(OPENFLOW2PCEP, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, (Object)Node.NodeIDType.OPENFLOW));
            compatibleType.put(OPENFLOW2ONEPK, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Short.class, (Object)Node.NodeIDType.OPENFLOW));
            compatibleType.put(PCEP2OPENFLOW, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Integer.class, (Object)Node.NodeIDType.PCEP));
            compatibleType.put(PCEP2ONEPK, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(Integer.class, (Object)Node.NodeIDType.PCEP));
            compatibleType.put(ONEPK2OPENFLOW, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(String.class, (Object)Node.NodeIDType.ONEPK));
            compatibleType.put(ONEPK2PCEP, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(String.class, (Object)Node.NodeIDType.ONEPK));
            compatibleType.put(PRODUCTION, (ImmutablePair<Class<? extends Object>, String>)new ImmutablePair(String.class, (Object)Node.NodeIDType.PRODUCTION));
        }
    }
}

