/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.INodeFactory;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement
public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object nodeID;
    private String nodeType;
    private String nodeIDString;

    private Node() {
        this.nodeID = null;
        this.nodeType = null;
        this.nodeIDString = null;
    }

    public Node(String nodeType, Object id) throws ConstructionException {
        if (NodeIDType.getClassType(nodeType) == null || !NodeIDType.getClassType(nodeType).isInstance(id)) {
            throw new ConstructionException("Type of incoming object:" + id.getClass() + " not compatible with expected type:" + NodeIDType.getClassType(nodeType));
        }
        this.nodeType = nodeType;
        this.nodeID = id;
    }

    public Node(Node src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("Null incoming object to copy from");
        }
        this.nodeType = src.getType();
        this.nodeID = src.getID();
    }

    @XmlElement(name="type")
    public String getType() {
        return this.nodeType;
    }

    private void fillmeFromString(String typeStr, String IDStr) {
        if (typeStr == null) {
            return;
        }
        if (IDStr == null) {
            return;
        }
        this.nodeType = typeStr;
        if (typeStr.equals(NodeIDType.OPENFLOW)) {
            this.nodeID = HexEncode.stringToLong(IDStr);
        } else if (typeStr.equals(NodeIDType.ONEPK)) {
            this.nodeID = IDStr;
        } else if (typeStr.equals(NodeIDType.PCEP)) {
            this.nodeID = UUID.fromString(IDStr);
        } else if (typeStr.equals(NodeIDType.PRODUCTION)) {
            this.nodeID = IDStr;
        } else {
            INodeFactory f = (INodeFactory)ServiceHelper.getGlobalInstance(INodeFactory.class, new Node(), "(protocolName=" + typeStr + ")");
            if (f != null) {
                Node n = f.fromString(typeStr, IDStr);
                this.nodeID = n.nodeID;
            }
        }
    }

    private void setType(String type) {
        this.nodeType = type;
        if (this.nodeIDString != null) {
            this.fillmeFromString(type, this.nodeIDString);
        }
    }

    public Object getID() {
        return this.nodeID;
    }

    @XmlElement(name="id")
    public String getNodeIDString() {
        if (this.nodeType.equals(NodeIDType.OPENFLOW)) {
            return HexEncode.longToHexString((Long)this.nodeID);
        }
        return this.nodeID.toString();
    }

    private void setNodeIDString(String nodeIDString) {
        this.nodeIDString = nodeIDString;
        if (this.nodeType != null) {
            this.fillmeFromString(this.nodeType, nodeIDString);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        result = 31 * result + (this.nodeType == null ? 0 : this.nodeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.nodeID == null ? other.nodeID != null : !this.nodeID.equals(other.nodeID)) {
            return false;
        }
        return !(this.nodeType == null ? other.nodeType != null : !this.nodeType.equals(other.nodeType));
    }

    public String toString() {
        if (this.nodeType.equals(NodeIDType.OPENFLOW)) {
            return this.nodeType + "|" + HexEncode.longToHexString((Long)this.nodeID);
        }
        return this.nodeType + "|" + this.nodeID.toString();
    }

    public static Node fromString(String str) {
        if (str == null) {
            return null;
        }
        String[] parts = str.split("\\|");
        if (parts.length != 2) {
            String numStr = str.toUpperCase();
            Long ofNodeID = null;
            if (numStr.startsWith("0X")) {
                try {
                    BigInteger b = new BigInteger(numStr.replaceFirst("0X", ""), 16);
                    ofNodeID = b.longValue();
                }
                catch (Exception ex) {
                    ofNodeID = null;
                }
            } else {
                try {
                    BigInteger b = new BigInteger(numStr);
                    ofNodeID = b.longValue();
                }
                catch (Exception ex) {
                    ofNodeID = null;
                }
            }
            if (ofNodeID == null) {
                try {
                    ofNodeID = HexEncode.stringToLong(numStr);
                }
                catch (Exception ex) {
                    ofNodeID = null;
                }
            }
            if (ofNodeID == null) {
                return null;
            }
            try {
                return new Node(NodeIDType.OPENFLOW, ofNodeID);
            }
            catch (ConstructionException ex) {
                return null;
            }
        }
        String typeStr = parts[0];
        String IDStr = parts[1];
        return Node.fromString(typeStr, IDStr);
    }

    public static Node fromString(String typeStr, String IDStr) {
        if (typeStr == null) {
            return null;
        }
        if (IDStr == null) {
            return null;
        }
        if (typeStr.equals(NodeIDType.OPENFLOW)) {
            try {
                Long ID = HexEncode.stringToLong(IDStr);
                return new Node(typeStr, ID);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (typeStr.equals(NodeIDType.ONEPK)) {
            try {
                return new Node(typeStr, IDStr);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (typeStr.equals(NodeIDType.PCEP)) {
            try {
                UUID ID = UUID.fromString(IDStr);
                return new Node(typeStr, ID);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (typeStr.equals(NodeIDType.PRODUCTION)) {
            try {
                return new Node(typeStr, IDStr);
            }
            catch (Exception ex) {
                return null;
            }
        }
        INodeFactory f = (INodeFactory)ServiceHelper.getGlobalInstance(INodeFactory.class, new Node(), "(protocolName=" + typeStr + ")");
        if (f == null) {
            return null;
        }
        return f.fromString(typeStr, IDStr);
    }

    public static final class NodeIDType {
        private static final ConcurrentHashMap<String, Class<? extends Object>> compatibleType = new ConcurrentHashMap();
        public static String OPENFLOW = "OF";
        public static String PCEP = "PE";
        public static String ONEPK = "PK";
        public static String PRODUCTION = "PR";

        public static Class<?> getClassType(String nodeType) {
            return compatibleType.get(nodeType);
        }

        public static Set<String> values() {
            return compatibleType.keySet();
        }

        public static boolean registerIDType(String type, Class<? extends Object> compatibleID) {
            if (compatibleType.get(type) != null) {
                return false;
            }
            compatibleType.put(type, compatibleID);
            return true;
        }

        public static void unRegisterIDType(String type) {
            compatibleType.remove(type);
        }

        static {
            compatibleType.put(OPENFLOW, Long.class);
            compatibleType.put(PCEP, UUID.class);
            compatibleType.put(ONEPK, String.class);
            compatibleType.put(PRODUCTION, String.class);
        }
    }
}

