/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.HexEncode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class MacAddress
extends Property
implements Cloneable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    private final String address;
    public static final String name = "macAddress";

    private MacAddress() {
        super(name);
        this.address = null;
    }

    public MacAddress(byte[] nodeMacAddress) {
        super(name);
        this.address = HexEncode.bytesToHexStringFormat(nodeMacAddress);
    }

    public MacAddress(String nodeMacAddress) {
        super(name);
        this.address = nodeMacAddress;
    }

    public byte[] getMacAddress() {
        return HexEncode.bytesFromHexString(this.address);
    }

    @Override
    public MacAddress clone() {
        return new MacAddress(this.address);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MacAddress other = (MacAddress)obj;
        return this.address.equals(other.address);
    }

    @Override
    public String toString() {
        return "MacAddress[" + this.address + "]";
    }

    @Override
    public String getStringValue() {
        return this.address;
    }
}

