/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Latency
extends Property {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    private long latencyValue;
    public static final long LATENCYUNK = 0L;
    public static final long LATENCY1ns = (long)Math.pow(10.0, 3.0);
    public static final long LATENCY10ns = (long)Math.pow(10.0, 4.0);
    public static final long LATENCY100ns = (long)Math.pow(10.0, 5.0);
    public static final long LATENCY1us = (long)Math.pow(10.0, 6.0);
    public static final long LATENCY10us = (long)Math.pow(10.0, 7.0);
    public static final long LATENCY100us = (long)Math.pow(10.0, 8.0);
    public static final long LATENCY1ms = (long)Math.pow(10.0, 9.0);
    public static final long LATENCY1s = (long)Math.pow(10.0, 12.0);
    public static final String LatencyPropName = "latency";

    private Latency() {
        super(LatencyPropName);
        this.latencyValue = 0L;
    }

    public Latency(long latency) {
        super(LatencyPropName);
        this.latencyValue = latency;
    }

    public Latency(int latency) {
        super(LatencyPropName);
        this.latencyValue = latency;
    }

    public Latency(short latency) {
        super(LatencyPropName);
        this.latencyValue = latency;
    }

    @Override
    public Latency clone() {
        return new Latency(this.latencyValue);
    }

    public long getValue() {
        return this.latencyValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.latencyValue ^ this.latencyValue >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Latency other = (Latency)obj;
        return this.latencyValue == other.latencyValue;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Latency[");
        if (this.latencyValue == 0L) {
            sb.append("UnKnown");
        } else if (this.latencyValue < LATENCY1ns) {
            sb.append(this.latencyValue).append("psec");
        } else if (this.latencyValue < LATENCY1us) {
            sb.append(Long.toString(this.latencyValue / LATENCY1ns)).append("nsec");
        } else if (this.latencyValue < LATENCY1ms) {
            sb.append(Long.toString(this.latencyValue / LATENCY1us)).append("usec");
        } else if (this.latencyValue < LATENCY1s) {
            sb.append(Long.toString(this.latencyValue / LATENCY1ms)).append("msec");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStringValue() {
        if (this.latencyValue == 0L) {
            return "UnKnown";
        }
        if (this.latencyValue < LATENCY1ns) {
            return this.latencyValue + "psec";
        }
        if (this.latencyValue < LATENCY1us) {
            return Long.toString(this.latencyValue / LATENCY1ns) + "nsec";
        }
        if (this.latencyValue < LATENCY1ms) {
            return Long.toString(this.latencyValue / LATENCY1us) + "usec";
        }
        if (this.latencyValue < LATENCY1s) {
            return Long.toString(this.latencyValue / LATENCY1ms) + "msec";
        }
        return Long.toString(this.latencyValue) + "sec";
    }
}

