/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import java.net.InetAddress;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.packet.address.DataLinkAddress;

@XmlRootElement(name="host")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Host
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private DataLinkAddress dataLayerAddress;
    private InetAddress networkAddress;

    public Host() {
    }

    public Host(DataLinkAddress dataLayerAddress, InetAddress networkAddress) throws ConstructionException {
        if (dataLayerAddress == null) {
            throw new ConstructionException("Passed null datalink address");
        }
        if (networkAddress == null) {
            throw new ConstructionException("Passed null network address");
        }
        this.dataLayerAddress = dataLayerAddress;
        this.networkAddress = networkAddress;
    }

    public Host(Host h) throws ConstructionException {
        if (h == null) {
            throw new ConstructionException("Passed null host");
        }
        this.dataLayerAddress = h.getDataLayerAddress();
        this.networkAddress = h.getNetworkAddress();
    }

    public DataLinkAddress getDataLayerAddress() {
        return this.dataLayerAddress;
    }

    public InetAddress getNetworkAddress() {
        return this.networkAddress;
    }

    @XmlElement(name="networkAddress")
    public String getNetworkAddressAsString() {
        return this.networkAddress.getHostAddress();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataLayerAddress == null ? 0 : this.dataLayerAddress.hashCode());
        result = 31 * result + (this.networkAddress == null ? 0 : this.networkAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Host other = (Host)obj;
        if (this.dataLayerAddress == null ? other.dataLayerAddress != null : !this.dataLayerAddress.equals(other.dataLayerAddress)) {
            return false;
        }
        return !(this.networkAddress == null ? other.networkAddress != null : !this.networkAddress.equals(other.networkAddress));
    }

    public String toString() {
        return "Host [dataLayerAddress=" + this.dataLayerAddress + ", networkAddress=" + this.networkAddress + "]";
    }
}

