/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ForwardingMode
extends Property {
    @XmlElement(name="value")
    private final int modeValue;
    public static final int REACTIVE_FORWARDING = 0;
    public static final int PROACTIVE_FORWARDING = 1;
    public static final String name = "forwarding";

    private ForwardingMode() {
        super(name);
        this.modeValue = 0;
    }

    public ForwardingMode(int mode) {
        super(name);
        this.modeValue = mode;
    }

    public int getValue() {
        return this.modeValue;
    }

    public boolean isProactive() {
        return this.modeValue == 1;
    }

    public boolean isValid() {
        return this.modeValue >= 0 && this.modeValue <= 1;
    }

    @Override
    public ForwardingMode clone() {
        return new ForwardingMode(this.modeValue);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.modeValue;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForwardingMode other = (ForwardingMode)obj;
        return this.modeValue == other.modeValue;
    }

    @Override
    public String toString() {
        return "Mode[" + this.modeValue + "]";
    }

    @Override
    public String getStringValue() {
        return this.modeValue == 1 ? "Proactive" : "Reactive";
    }
}

