/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.NodeConnector;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Edge
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private NodeConnector tailNodeConnector;
    @XmlElement
    private NodeConnector headNodeConnector;

    private Edge() {
        this.tailNodeConnector = null;
        this.headNodeConnector = null;
    }

    public Edge(NodeConnector tailNodeConnector, NodeConnector headNodeConnector) throws ConstructionException {
        if (tailNodeConnector == null || headNodeConnector == null) {
            throw new ConstructionException("Null tail or head NodeConnector supplied");
        }
        this.tailNodeConnector = tailNodeConnector;
        this.headNodeConnector = headNodeConnector;
    }

    public Edge(Edge src) throws ConstructionException {
        if (src == null) {
            throw new ConstructionException("src supplied was null");
        }
        this.tailNodeConnector = new NodeConnector(src.getTailNodeConnector());
        this.headNodeConnector = new NodeConnector(src.getHeadNodeConnector());
    }

    public NodeConnector getTailNodeConnector() {
        return this.tailNodeConnector;
    }

    public void setTailNodeConnector(NodeConnector tailNodeConnector) {
        this.tailNodeConnector = tailNodeConnector;
    }

    public NodeConnector getHeadNodeConnector() {
        return this.headNodeConnector;
    }

    public void setHeadNodeConnector(NodeConnector headNodeConnector) {
        this.headNodeConnector = headNodeConnector;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headNodeConnector == null ? 0 : this.headNodeConnector.hashCode());
        result = 31 * result + (this.tailNodeConnector == null ? 0 : this.tailNodeConnector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.headNodeConnector == null ? other.headNodeConnector != null : !this.headNodeConnector.equals(other.headNodeConnector)) {
            return false;
        }
        return !(this.tailNodeConnector == null ? other.tailNodeConnector != null : !this.tailNodeConnector.equals(other.tailNodeConnector));
    }

    public String toString() {
        return "(" + this.tailNodeConnector + "->" + this.headNodeConnector + ")";
    }
}

