/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.util.Dictionary;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivation;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.ServiceReference;

public class ContainerServiceDependency
implements ServiceDependency,
DependencyActivation {
    private ServiceDependency m_dep;
    private String containerName;

    public ContainerServiceDependency(DependencyManager manager, String containerName) {
        this.m_dep = manager.createServiceDependency();
        this.containerName = containerName;
    }

    private ContainerServiceDependency(ServiceDependency explicitDependency, String containerName) {
        this.m_dep = explicitDependency;
        this.containerName = containerName;
    }

    public ServiceDependency setService(Class serviceName) {
        this.m_dep.setService(serviceName, "(containerName=" + this.containerName + ")");
        return this;
    }

    public ServiceDependency setService(Class serviceName, String serviceFilter) {
        this.m_dep.setService(serviceName, "(&(containerName=" + this.containerName + ")" + serviceFilter + ")");
        return this;
    }

    public ServiceDependency setService(String serviceFilter) {
        this.m_dep.setService("(&(containerName=" + this.containerName + ")" + serviceFilter + ")");
        return this;
    }

    public ServiceDependency setService(Class serviceName, ServiceReference serviceReference) {
        this.m_dep.setService(serviceName, serviceReference);
        return this;
    }

    public ServiceDependency setDefaultImplementation(Object implementation) {
        this.m_dep.setDefaultImplementation(implementation);
        return this;
    }

    public ServiceDependency setRequired(boolean required) {
        this.m_dep.setRequired(required);
        return this;
    }

    public ServiceDependency setAutoConfig(boolean autoConfig) {
        this.m_dep.setAutoConfig(autoConfig);
        return this;
    }

    public ServiceDependency setAutoConfig(String instanceName) {
        this.m_dep.setAutoConfig(instanceName);
        return this;
    }

    public ServiceDependency setCallbacks(String added, String removed) {
        this.m_dep.setCallbacks(added, removed);
        return this;
    }

    public ServiceDependency setCallbacks(String added, String changed, String removed) {
        this.m_dep.setCallbacks(added, changed, removed);
        return this;
    }

    public ServiceDependency setCallbacks(String added, String changed, String removed, String swapped) {
        this.m_dep.setCallbacks(added, changed, removed, swapped);
        return this;
    }

    public ServiceDependency setCallbacks(Object instance, String added, String removed) {
        this.m_dep.setCallbacks(instance, added, removed);
        return this;
    }

    public ServiceDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.m_dep.setCallbacks(instance, added, changed, removed);
        return this;
    }

    public ServiceDependency setCallbacks(Object instance, String added, String changed, String removed, String swapped) {
        this.m_dep.setCallbacks(instance, added, changed, removed, swapped);
        return this;
    }

    public ServiceDependency setPropagate(boolean propagate) {
        this.m_dep.setPropagate(propagate);
        return this;
    }

    public ServiceDependency setPropagate(Object instance, String method) {
        this.m_dep.setPropagate(instance, method);
        return this;
    }

    public ServiceDependency setInstanceBound(boolean isInstanceBound) {
        this.m_dep.setInstanceBound(isInstanceBound);
        return this;
    }

    public Dependency createCopy() {
        return new ContainerServiceDependency((ServiceDependency)this.m_dep.createCopy(), this.containerName);
    }

    public Dictionary getProperties() {
        return this.m_dep.getProperties();
    }

    public boolean isPropagated() {
        return this.m_dep.isPropagated();
    }

    public boolean isRequired() {
        return this.m_dep.isRequired();
    }

    public boolean isAvailable() {
        return this.m_dep.isAvailable();
    }

    public boolean isInstanceBound() {
        return this.m_dep.isInstanceBound();
    }

    public boolean isAutoConfig() {
        return this.m_dep.isAutoConfig();
    }

    public Class getAutoConfigType() {
        return this.m_dep.getAutoConfigType();
    }

    public Object getAutoConfigInstance() {
        return this.m_dep.getAutoConfigInstance();
    }

    public String getAutoConfigName() {
        return this.m_dep.getAutoConfigName();
    }

    public void invokeAdded(DependencyService service) {
        this.m_dep.invokeAdded(service);
    }

    public void invokeRemoved(DependencyService service) {
        this.m_dep.invokeRemoved(service);
    }

    public String getName() {
        return this.m_dep.getName();
    }

    public String getType() {
        return this.m_dep.getType();
    }

    public int getState() {
        return this.m_dep.getState();
    }

    public void start(DependencyService service) {
        DependencyActivation a = (DependencyActivation)this.m_dep;
        a.start(service);
    }

    public void stop(DependencyService service) {
        DependencyActivation a = (DependencyActivation)this.m_dep;
        a.stop(service);
    }
}

