/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.io.Serializable;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.SetDlType;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.action.SetTpDst;
import org.opendaylight.controller.sal.action.SetTpSrc;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;

public class ContainerFlow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Match match;

    public ContainerFlow(Match match) {
        this.match = match;
    }

    public Match getMatch() {
        return this.match.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerFlow other = (ContainerFlow)obj;
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    public String toString() {
        return "Container Flow [" + this.match.toString() + "]";
    }

    public boolean allowsFlow(Flow flow) {
        Match target = flow.getMatch();
        if (!this.allowsMatch(target)) {
            return false;
        }
        if (flow.getActions() == null) {
            return true;
        }
        Match actionMatch = new Match();
        for (Action action : flow.getActions()) {
            switch (action.getType()) {
                case SET_DL_TYPE: {
                    actionMatch.setField(MatchType.DL_TYPE, Integer.valueOf(((SetDlType)action).getDlType()).shortValue());
                    break;
                }
                case SET_NW_SRC: {
                    actionMatch.setField(MatchType.NW_SRC, ((SetNwSrc)action).getAddress());
                    break;
                }
                case SET_NW_DST: {
                    actionMatch.setField(MatchType.NW_DST, ((SetNwDst)action).getAddress());
                    break;
                }
                case SET_TP_SRC: {
                    actionMatch.setField(MatchType.TP_SRC, Integer.valueOf(((SetTpSrc)action).getPort()).shortValue());
                    break;
                }
                case SET_TP_DST: {
                    actionMatch.setField(MatchType.TP_DST, Integer.valueOf(((SetTpDst)action).getPort()).shortValue());
                    break;
                }
            }
        }
        return this.allowsMatch(actionMatch);
    }

    public boolean allowsMatch(Match target) {
        return !target.conflictWithFilter(this.match);
    }
}

