/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.opendaylight.controller.sal.core.ContainerServiceDependency;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentActivatorAbstractBase
implements BundleActivator,
IContainerAware {
    Logger logger = LoggerFactory.getLogger(ComponentActivatorAbstractBase.class);
    private DependencyManager dm;
    private ConcurrentMap<ImmutablePair<String, Object>, Component> dbInstances = new ConcurrentHashMap<ImmutablePair<String, Object>, Component>();
    private ConcurrentMap<Object, Component> dbGlobalInstances = new ConcurrentHashMap<Object, Component>();

    protected void init() {
    }

    public void destroy() {
    }

    protected Object[] getImplementations() {
        return null;
    }

    protected Object[] getGlobalImplementations() {
        return null;
    }

    protected void configureInstance(Component c, Object imp, String containerName) {
    }

    protected void configureGlobalInstance(Component c, Object imp) {
    }

    @Override
    public void containerCreate(String containerName) {
        try {
            Object[] imps = this.getImplementations();
            this.logger.trace("Creating instance {}", (Object)containerName);
            if (imps != null) {
                for (int i = 0; i < imps.length; ++i) {
                    ImmutablePair key = new ImmutablePair((Object)containerName, imps[i]);
                    Component c = (Component)this.dbInstances.get(key);
                    if (c == null) {
                        Hashtable<String, String> serviceProps;
                        c = this.dm.createComponent();
                        c.addStateListener((ComponentStateListener)new ListenerComponentStates());
                        this.configureInstance(c, imps[i], containerName);
                        if (c.getService() == null) {
                            this.logger.trace("Setting implementation to: {}", imps[i]);
                            c.setImplementation(imps[i]);
                        }
                        if ((serviceProps = c.getServiceProperties()) != null) {
                            this.logger.trace("Adding new property for container");
                            ((Dictionary)serviceProps).put("containerName", containerName);
                        } else {
                            this.logger.trace("Create a new properties for the service");
                            serviceProps = new Hashtable<String, String>();
                            ((Dictionary)serviceProps).put("containerName", containerName);
                        }
                        c.setServiceProperties(serviceProps);
                        this.dm.add(c);
                        this.dbInstances.put((ImmutablePair<String, Object>)key, c);
                        continue;
                    }
                    this.logger.error("I have been asked again to create an instance on: " + containerName + "for object: " + imps[i] + "when i already have it!!");
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("During containerDestroy invocation caught exception: " + ex + "\nStacktrace:" + this.stackToString(ex.getStackTrace()));
        }
    }

    @Override
    public void containerDestroy(String containerName) {
        try {
            Object[] imps = this.getImplementations();
            this.logger.trace("Destroying instance {}", (Object)containerName);
            if (imps != null) {
                for (int i = 0; i < imps.length; ++i) {
                    ImmutablePair key = new ImmutablePair((Object)containerName, imps[i]);
                    Component c = (Component)this.dbInstances.get(key);
                    if (c != null) {
                        if (c.getService() != null) {
                            c.invokeCallbackMethod(new Object[]{c.getService()}, "containerStop", (Class[][])new Class[][]{{Component.class}, new Class[0]}, (Object[][])new Object[][]{{c}, new Object[0]});
                        }
                        this.dm.remove(c);
                    } else {
                        this.logger.error("I have been asked again to remove an instance on: " + containerName + "for object: " + imps[i] + "when i already have cleared it!!");
                    }
                    this.dbInstances.remove(key);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("During containerDestroy invocation caught exception: " + ex + "\nStacktrace:" + this.stackToString(ex.getStackTrace()));
        }
    }

    private String stackToString(StackTraceElement[] stack) {
        if (stack == null) {
            return "<EmptyStack>";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < stack.length; ++i) {
            buffer.append("\n\t").append(stack[i].toString());
        }
        return buffer.toString();
    }

    public void start(BundleContext context) {
        try {
            this.dm = new DependencyManager(context);
            this.logger.trace("Activating");
            Object[] imps = this.getGlobalImplementations();
            if (imps != null) {
                for (int i = 0; i < imps.length; ++i) {
                    Object key = imps[i];
                    Component c = (Component)this.dbGlobalInstances.get(key);
                    if (c == null) {
                        try {
                            c = this.dm.createComponent();
                            c.addStateListener((ComponentStateListener)new ListenerComponentStates());
                            this.configureGlobalInstance(c, imps[i]);
                            if (c.getService() == null) {
                                this.logger.trace("Setting implementation to: {}", imps[i]);
                                c.setImplementation(imps[i]);
                            }
                            this.dm.add(c);
                        }
                        catch (Exception nex) {
                            this.logger.error("During creation of a Global instance caught exception: " + nex + "\nStacktrace:" + this.stackToString(nex.getStackTrace()));
                        }
                        if (c == null) continue;
                        this.dbGlobalInstances.put(key, c);
                        continue;
                    }
                    this.logger.error("I have been asked again to create an instance  Global for object: " + imps[i] + "when i already have it!!");
                }
            }
            context.registerService(IContainerAware.class.getName(), (Object)this, null);
            this.init();
            this.logger.trace("Activation DONE!");
        }
        catch (Exception ex) {
            this.logger.error("During Activator start caught exception: " + ex + "\nStacktrace:" + this.stackToString(ex.getStackTrace()));
        }
    }

    public void stop(BundleContext context) {
        try {
            Component c;
            this.logger.trace("DE-Activating");
            this.destroy();
            for (Object key : this.dbInstances.keySet()) {
                try {
                    c = (Component)this.dbInstances.get(key);
                    if (c != null) {
                        this.logger.trace("Remove component on container: {} Object: {}", key.getLeft(), key.getRight());
                        this.dm.remove(c);
                    }
                }
                catch (Exception nex) {
                    this.logger.error("During removal of a container component instance caught exception: " + nex + "\nStacktrace:" + this.stackToString(nex.getStackTrace()));
                }
                this.dbInstances.remove(key);
            }
            for (Object key : this.dbGlobalInstances.keySet()) {
                try {
                    c = (Component)this.dbGlobalInstances.get(key);
                    if (c != null) {
                        this.logger.trace("Remove component for Object: {}", key);
                        this.dm.remove(c);
                    }
                }
                catch (Exception nex) {
                    this.logger.error("During removal of a Global instance caught exception: " + nex + "\nStacktrace:" + this.stackToString(nex.getStackTrace()));
                }
                this.dbGlobalInstances.remove(key);
            }
            this.dm = null;
            this.logger.trace("Deactivation DONE!");
        }
        catch (Exception ex) {
            this.logger.error("During Activator stop caught exception: " + ex + "\nStacktrace:" + this.stackToString(ex.getStackTrace()));
        }
    }

    protected ServiceDependency createContainerServiceDependency(String containerName) {
        return new ContainerServiceDependency(this.dm, containerName);
    }

    protected ServiceDependency createServiceDependency() {
        return this.dm.createServiceDependency();
    }

    class ListenerComponentStates
    implements ComponentStateListener {
        ListenerComponentStates() {
        }

        public void starting(Component component) {
        }

        public void started(Component component) {
            if (component == null) {
                return;
            }
            component.invokeCallbackMethod(new Object[]{component.getService()}, "started", (Class[][])new Class[][]{{Component.class}, new Class[0]}, (Object[][])new Object[][]{{component}, new Object[0]});
        }

        public void stopped(Component component) {
        }

        public void stopping(Component component) {
            if (component == null) {
                return;
            }
            component.invokeCallbackMethod(new Object[]{component.getService()}, "stopping", (Class[][])new Class[][]{{Component.class}, new Class[0]}, (Object[][])new Object[][]{{component}, new Object[0]});
        }
    }
}

