/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Capabilities
extends Property {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    private int capabilitiesValue;
    public static final String CapabilitiesPropName = "capabilities";

    public Capabilities(int capabilities) {
        super(CapabilitiesPropName);
        this.capabilitiesValue = capabilities;
    }

    private Capabilities() {
        super(CapabilitiesPropName);
        this.capabilitiesValue = 0;
    }

    @Override
    public Capabilities clone() {
        return new Capabilities(this.capabilitiesValue);
    }

    public int getValue() {
        return this.capabilitiesValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.capabilitiesValue;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capabilities other = (Capabilities)obj;
        return this.capabilitiesValue == other.capabilitiesValue;
    }

    @Override
    public String toString() {
        return "Capabilities[" + this.capabilitiesValue + "]";
    }

    @Override
    public String getStringValue() {
        return Integer.toHexString(this.capabilitiesValue);
    }

    public static enum CapabilitiesType {
        FLOW_STATS_CAPABILITY(1),
        TABLE_STATS_CAPABILITY(2),
        PORT_STATS_CAPABILITY(4),
        STP_CAPABILITY(8),
        RSVD_CAPABILITY(16),
        IP_REASSEM_CAPABILITY(32),
        QUEUE_STATS_CAPABILITY(64),
        ARP_MATCH_IP_CAPABILITY(128);

        private final int ct;

        private CapabilitiesType(int val) {
            this.ct = val;
        }

        public int getValue() {
            return this.ct;
        }
    }
}

