/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.core.Property;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class Bandwidth
extends Property {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="value")
    protected long bandwidthValue;
    public static final long BWUNK = 0L;
    public static final long BW1Kbps = (long)Math.pow(10.0, 3.0);
    public static final long BW1Mbps = (long)Math.pow(10.0, 6.0);
    public static final long BW10Mbps = (long)Math.pow(10.0, 7.0);
    public static final long BW100Mbps = (long)Math.pow(10.0, 8.0);
    public static final long BW1Gbps = (long)Math.pow(10.0, 9.0);
    public static final long BW10Gbps = (long)Math.pow(10.0, 10.0);
    public static final long BW40Gbps = 4L * (long)Math.pow(10.0, 10.0);
    public static final long BW100Gbps = (long)Math.pow(10.0, 11.0);
    public static final long BW400Gbps = 4L * (long)Math.pow(10.0, 11.0);
    public static final long BW1Tbps = (long)Math.pow(10.0, 12.0);
    public static final long BW1Pbps = (long)Math.pow(10.0, 15.0);
    public static final String BandwidthPropName = "bandwidth";

    private Bandwidth() {
        super(BandwidthPropName);
        this.bandwidthValue = 0L;
    }

    public Bandwidth(long bandwidth) {
        super(BandwidthPropName);
        this.bandwidthValue = bandwidth;
    }

    public Bandwidth(int bandwidth) {
        super(BandwidthPropName);
        this.bandwidthValue = bandwidth;
    }

    public Bandwidth(short bandwidth) {
        super(BandwidthPropName);
        this.bandwidthValue = bandwidth;
    }

    public Bandwidth(String name) {
        super(name);
    }

    @Override
    public Bandwidth clone() {
        return new Bandwidth(this.bandwidthValue);
    }

    public long getValue() {
        return this.bandwidthValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.bandwidthValue ^ this.bandwidthValue >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bandwidth other = (Bandwidth)obj;
        return this.bandwidthValue == other.bandwidthValue;
    }

    @Override
    public String toString() {
        return "BandWidth[" + this.getStringValue() + "]";
    }

    @Override
    public String getStringValue() {
        if (this.bandwidthValue == 0L) {
            return "UnKnown";
        }
        if (this.bandwidthValue < BW1Kbps) {
            return this.bandwidthValue + "bps";
        }
        if (this.bandwidthValue < BW1Mbps) {
            return Long.toString(this.bandwidthValue / BW1Kbps) + "Kbps";
        }
        if (this.bandwidthValue < BW1Gbps) {
            return Long.toString(this.bandwidthValue / BW1Mbps) + "Mbps";
        }
        if (this.bandwidthValue < BW1Tbps) {
            return Long.toString(this.bandwidthValue / BW1Gbps) + "Gbps";
        }
        if (this.bandwidthValue < BW1Pbps) {
            return Long.toString(this.bandwidthValue / BW1Tbps) + "Tbps";
        }
        return this.bandwidthValue + "bps";
    }
}

