/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.authorization;

import java.io.Serializable;

public enum AppRoleLevel implements Serializable
{
    APPADMIN(0, "App-Admin", "Application Administrator"),
    APPUSER(1, "App-User", "Application User"),
    APPOPERATOR(2, "App-Operator", "Application Operator"),
    NOUSER(255, "Unknown User", "Unknown User");

    private int userLevel;
    private String level;
    private String prettyLevel;

    private AppRoleLevel(int userlevel, String level, String prettyLevel) {
        this.userLevel = userlevel;
        this.level = level;
        this.prettyLevel = prettyLevel;
    }

    public int toNumber() {
        return this.userLevel;
    }

    public String toString() {
        return this.level;
    }

    public String toStringPretty() {
        return this.prettyLevel;
    }

    public static AppRoleLevel fromString(String levelString) {
        for (AppRoleLevel rolelevel : AppRoleLevel.values()) {
            if (!rolelevel.toString().equals(levelString)) continue;
            return rolelevel;
        }
        return null;
    }
}

