/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.action;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.utils.HexEncode;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SetDlDst
extends Action {
    private static final long serialVersionUID = 1L;
    private byte[] address;

    private SetDlDst() {
    }

    public SetDlDst(byte[] dlAddress) {
        this.type = ActionType.SET_DL_DST;
        this.address = (byte[])dlAddress.clone();
    }

    public byte[] getDlAddress() {
        return (byte[])this.address.clone();
    }

    @XmlElement(name="address")
    public String getDlAddressString() {
        return HexEncode.bytesToHexString(this.address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetDlDst other = (SetDlDst)obj;
        return Arrays.equals(this.address, other.address);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.address);
        return result;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + "[address = " + HexEncode.bytesToHexString(this.address) + "]";
    }
}

