/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.action;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.utils.EtherTypes;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class PushVlan
extends Action {
    private static final long serialVersionUID = 1L;
    private int tag;
    private int pcp;
    private int cfi;
    private int vlanId;
    private transient int tci;
    private transient int header;

    private PushVlan() {
    }

    public PushVlan(int tag, int pcp, int cfi, int vlanId) {
        this.type = ActionType.PUSH_VLAN;
        this.tag = tag;
        this.cfi = cfi;
        this.pcp = pcp;
        this.vlanId = vlanId;
        this.tci = this.createTci();
        this.header = this.createHeader();
        this.runChecks();
    }

    public PushVlan(EtherTypes tag, int pcp, int cfi, int vlanId) {
        this.type = ActionType.PUSH_VLAN;
        this.tag = tag.intValue();
        this.cfi = cfi;
        this.pcp = pcp;
        this.vlanId = vlanId;
        this.tci = this.createTci();
        this.header = this.createHeader();
        this.runChecks();
    }

    private int createTci() {
        return (this.pcp & 7) << 13 | (this.cfi & 1) << 12 | this.vlanId & 0xFFF;
    }

    private int createHeader() {
        return (this.tag & 0xFFFF) << 16 | (this.pcp & 7) << 13 | (this.cfi & 1) << 12 | this.vlanId & 0xFFF;
    }

    private void runChecks() {
        this.checkValue(ActionType.SET_DL_TYPE, this.tag);
        this.checkValue(ActionType.SET_VLAN_PCP, this.pcp);
        this.checkValue(ActionType.SET_VLAN_CFI, this.cfi);
        this.checkValue(ActionType.SET_VLAN_ID, this.vlanId);
        this.checkValue(this.tci);
        if (this.tag != EtherTypes.VLANTAGGED.intValue() && this.tag != EtherTypes.QINQ.intValue() && this.tag != EtherTypes.OLDQINQ.intValue() && this.tag != EtherTypes.CISCOQINQ.intValue()) {
            this.checkValue(ActionType.SET_DL_TYPE, 0xBAD0000 | this.tag);
        }
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public int getCfi() {
        return this.cfi;
    }

    public int getPcp() {
        return this.pcp;
    }

    public int getTag() {
        return this.tag;
    }

    public int getTci() {
        return this.tci;
    }

    @XmlElement(name="VlanHeader")
    public int getHeader() {
        return this.header;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PushVlan other = (PushVlan)obj;
        if (this.cfi != other.cfi) {
            return false;
        }
        if (this.pcp != other.pcp) {
            return false;
        }
        if (this.tag != other.tag) {
            return false;
        }
        return this.vlanId == other.vlanId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.cfi;
        result = 31 * result + this.pcp;
        result = 31 * result + this.tag;
        result = 31 * result + this.vlanId;
        return result;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + "[tag = " + this.tag + ", pcp = " + this.pcp + ", cfi = " + this.cfi + ", vlanId = " + this.vlanId + "]";
    }
}

