/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.action;

public enum ActionType {
    DROP("drop", 0, 0),
    LOOPBACK("loopback", 0, 0),
    FLOOD("flood", 0, 0),
    FLOOD_ALL("floodAll", 0, 0),
    CONTROLLER("controller", 0, 0),
    INTERFACE("interface", 0, 0),
    SW_PATH("software path", 0, 0),
    HW_PATH("harware path", 0, 0),
    OUTPUT("output", 0, 65535),
    ENQUEUE("enqueue", 0, 65535),
    SET_DL_SRC("setDlSrc", 0, 0),
    SET_DL_DST("setDlDst", 0, 0),
    SET_VLAN_ID("setVlan", 1, 4095),
    SET_VLAN_PCP("setVlanPcp", 0, 7),
    SET_VLAN_CFI("setVlanCif", 0, 1),
    POP_VLAN("stripVlan", 0, 0),
    PUSH_VLAN("pushVlan", 0, 65535),
    SET_DL_TYPE("setDlType", 0, 65535),
    SET_NW_SRC("setNwSrc", 0, 0),
    SET_NW_DST("setNwDst", 0, 0),
    SET_NW_TOS("setNwTos", 0, 63),
    SET_TP_SRC("setTpSrc", 1, 65535),
    SET_TP_DST("setTpDst", 1, 65535),
    SET_NEXT_HOP("setNextHop", 0, 0);

    private String id;
    private int minValue;
    private int maxValue;

    private ActionType(String id, int minValue, int maxValue) {
        this.id = id;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getId() {
        return this.id;
    }

    public boolean isValidTarget(int value) {
        return value >= this.minValue && value <= this.maxValue;
    }

    public String getRange() {
        return "[0x" + Long.toHexString(this.minValue) + "-0x" + Long.toHexString(this.maxValue) + "]";
    }

    public boolean takesParameter() {
        switch (this) {
            case POP_VLAN: 
            case DROP: 
            case SW_PATH: 
            case HW_PATH: 
            case CONTROLLER: 
            case LOOPBACK: 
            case FLOOD: 
            case FLOOD_ALL: {
                return false;
            }
        }
        return true;
    }

    public int calculateConsistentHashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return 0;
    }
}

