/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.action;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.sal.action.ActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class Action
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Action.class);
    private static boolean debug = false;
    @XmlElement
    protected ActionType type;
    private transient boolean isValid = true;

    protected void checkValue(int value) {
        if (!this.type.isValidTarget(value)) {
            this.isValid = false;
            this.throwValueException(value);
        }
    }

    protected void checkValue(ActionType type, int value) {
        if (!type.isValidTarget(value)) {
            this.isValid = false;
            this.throwValueException(value);
        }
    }

    private void throwValueException(int value) {
        String error = "Invalid field value assignement. For type: " + this.type.getId() + " Expected: " + this.type.getRange() + ", Got: 0x" + Integer.toHexString(value);
        try {
            throw new Exception(error);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            if (debug) {
                logger.error("", (Throwable)e);
            }
            return;
        }
    }

    public ActionType getType() {
        return this.type;
    }

    public String getId() {
        return this.type.getId();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.calculateConsistentHashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        return this.type == other.type;
    }

    public String toString() {
        return this.type.toString();
    }
}

