/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.algorithms.blockmodel.VertexPartition;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructurallyEquivalent<V, E>
implements Transformer<Graph<V, E>, VertexPartition<V, E>> {
    @Override
    public VertexPartition<V, E> transform(Graph<V, E> g) {
        Set<Pair<V>> vertex_pairs = this.getEquivalentPairs(g);
        HashSet rv = new HashSet();
        HashMap intermediate = new HashMap();
        for (Pair<V> p : vertex_pairs) {
            HashSet<V> res = (HashSet<V>)intermediate.get(p.getFirst());
            if (res == null) {
                res = (Set)intermediate.get(p.getSecond());
            }
            if (res == null) {
                res = new HashSet<V>();
            }
            res.add(p.getFirst());
            res.add(p.getSecond());
            intermediate.put(p.getFirst(), res);
            intermediate.put(p.getSecond(), res);
        }
        rv.addAll(intermediate.values());
        Collection singletons = CollectionUtils.subtract(g.getVertices(), intermediate.keySet());
        for (Object v : singletons) {
            Set v_set = Collections.singleton(v);
            intermediate.put(v, v_set);
            rv.add(v_set);
        }
        return new VertexPartition<V, E>(g, intermediate, rv);
    }

    protected Set<Pair<V>> getEquivalentPairs(Graph<V, ?> g) {
        HashSet<Pair<V>> rv = new HashSet<Pair<V>>();
        HashSet alreadyEquivalent = new HashSet();
        ArrayList l = new ArrayList(g.getVertices());
        for (Object v1 : l) {
            if (alreadyEquivalent.contains(v1)) continue;
            ListIterator iterator = l.listIterator(l.indexOf(v1) + 1);
            while (iterator.hasNext()) {
                Object v2 = iterator.next();
                if (alreadyEquivalent.contains(v2) || !this.canPossiblyCompare(v1, v2) || !this.isStructurallyEquivalent(g, v1, v2)) continue;
                Pair p = new Pair(v1, v2);
                alreadyEquivalent.add(v2);
                rv.add(p);
            }
        }
        return rv;
    }

    protected boolean isStructurallyEquivalent(Graph<V, ?> g, V v1, V v2) {
        boolean b;
        if (g.degree(v1) != g.degree(v2)) {
            return false;
        }
        HashSet<V> n1 = new HashSet<V>(g.getPredecessors(v1));
        n1.remove(v2);
        n1.remove(v1);
        HashSet<V> n2 = new HashSet<V>(g.getPredecessors(v2));
        n2.remove(v1);
        n2.remove(v2);
        HashSet<V> o1 = new HashSet<V>(g.getSuccessors(v1));
        HashSet<V> o2 = new HashSet<V>(g.getSuccessors(v2));
        o1.remove(v1);
        o1.remove(v2);
        o2.remove(v1);
        o2.remove(v2);
        boolean bl = b = n1.equals(n2) && o1.equals(o2);
        if (!b) {
            return b;
        }
        b &= g.isSuccessor(v1, v2) == g.isSuccessor(v2, v1);
        return b &= g.isSuccessor(v1, v1) == g.isSuccessor(v2, v2);
    }

    protected boolean canPossiblyCompare(V v1, V v2) {
        return true;
    }
}

