/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.topology.IListenTopoUpdates;
import org.opendaylight.controller.sal.topology.IPluginInTopologyService;
import org.opendaylight.controller.sal.topology.IPluginOutTopologyService;
import org.opendaylight.controller.sal.topology.ITopologyService;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topology
implements IPluginOutTopologyService,
ITopologyService {
    protected static final Logger logger = LoggerFactory.getLogger(Topology.class);
    private Set<IListenTopoUpdates> updateService = Collections.synchronizedSet(new HashSet());
    private Set<IPluginInTopologyService> pluginService = Collections.synchronizedSet(new HashSet());

    void setPluginService(IPluginInTopologyService s) {
        if (this.pluginService != null) {
            this.pluginService.add(s);
        }
    }

    void unsetPluginService(IPluginInTopologyService s) {
        if (this.pluginService != null) {
            this.pluginService.remove(s);
        }
    }

    void setUpdateService(IListenTopoUpdates s) {
        if (this.updateService != null) {
            this.updateService.add(s);
        }
    }

    void unsetUpdateService(IListenTopoUpdates s) {
        if (this.updateService != null) {
            this.updateService.remove(s);
        }
    }

    void init() {
    }

    void destroy() {
        if (this.updateService != null) {
            this.updateService.clear();
        }
        if (this.pluginService != null) {
            this.pluginService.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sollicitRefresh() {
        Set<IPluginInTopologyService> set = this.pluginService;
        synchronized (set) {
            for (IPluginInTopologyService s : this.pluginService) {
                s.sollicitRefresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        Set<IListenTopoUpdates> set = this.updateService;
        synchronized (set) {
            for (IListenTopoUpdates s : this.updateService) {
                s.edgeUpdate(topoedgeupdateList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edgeOverUtilized(Edge edge) {
        Set<IListenTopoUpdates> set = this.updateService;
        synchronized (set) {
            for (IListenTopoUpdates s : this.updateService) {
                s.edgeOverUtilized(edge);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edgeUtilBackToNormal(Edge edge) {
        Set<IListenTopoUpdates> set = this.updateService;
        synchronized (set) {
            for (IListenTopoUpdates s : this.updateService) {
                s.edgeUtilBackToNormal(edge);
            }
        }
    }
}

