/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IPluginInReadService;
import org.opendaylight.controller.sal.reader.IPluginOutReadService;
import org.opendaylight.controller.sal.reader.IReadService;
import org.opendaylight.controller.sal.reader.IReadServiceListener;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.opendaylight.controller.sal.utils.NodeTableCreator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadService
implements IReadService,
CommandProvider,
IPluginOutReadService {
    protected static final Logger logger = LoggerFactory.getLogger(ReadService.class);
    private ConcurrentHashMap<String, IPluginInReadService> pluginReader = new ConcurrentHashMap();
    private Set<IReadServiceListener> readerListeners = new CopyOnWriteArraySet<IReadServiceListener>();

    void init() {
    }

    void destroy() {
        this.pluginReader.clear();
        this.readerListeners.clear();
    }

    void start() {
        this.registerWithOSGIConsole();
    }

    void stop() {
    }

    public void setService(Map<?, ?> props, IPluginInReadService s) {
        if (this.pluginReader == null) {
            logger.error("pluginReader store null");
            return;
        }
        logger.trace("Got a service set request {}", (Object)s);
        String type = null;
        Iterator<Map.Entry<?, ?>> i$ = props.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<?, ?> e;
            Map.Entry<?, ?> entry = e = i$.next();
            logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
        }
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a pluginReader without any protocolPluginType provided");
        } else {
            this.pluginReader.put(type, s);
            logger.debug("Stored the pluginReader for type: {}", (Object)type);
        }
    }

    public void unsetService(Map<?, ?> props, IPluginInReadService s) {
        if (this.pluginReader == null) {
            logger.error("pluginReader store null");
            return;
        }
        String type = null;
        logger.debug("Received unsetpluginReader request");
        Iterator<Map.Entry<?, ?>> i$ = props.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<?, ?> e;
            Map.Entry<?, ?> entry = e = i$.next();
            logger.trace("Prop key:({}) value:({})", entry.getKey(), entry.getValue());
        }
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a pluginReader without any protocolPluginType provided");
        } else if (this.pluginReader.get(type).equals(s)) {
            this.pluginReader.remove(type);
            logger.debug("Removed the pluginReader for type: {}", (Object)type);
        }
    }

    public void setReaderListener(IReadServiceListener service) {
        logger.trace("Got a listener set request {}", (Object)service);
        this.readerListeners.add(service);
    }

    public void unsetReaderListener(IReadServiceListener service) {
        logger.trace("Got a listener Unset request");
        this.readerListeners.remove(service);
    }

    public FlowOnNode readFlow(Node node, Flow flow) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readFlow(node, flow, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public FlowOnNode nonCachedReadFlow(Node node, Flow flow) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readFlow(node, flow, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public List<FlowOnNode> readAllFlows(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readAllFlow(node, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return Collections.emptyList();
    }

    public List<FlowOnNode> nonCachedReadAllFlows(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readAllFlow(node, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return Collections.emptyList();
    }

    public NodeDescription readDescription(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readDescription(node, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public NodeDescription nonCachedReadDescription(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readDescription(node, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public NodeConnectorStatistics readNodeConnector(NodeConnector connector) {
        Node node = connector.getNode();
        if (this.pluginReader != null && node != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readNodeConnector(connector, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public NodeConnectorStatistics nonCachedReadNodeConnector(NodeConnector connector) {
        Node node = connector.getNode();
        if (this.pluginReader != null && node != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readNodeConnector(connector, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public List<NodeConnectorStatistics> readNodeConnectors(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readAllNodeConnector(node, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return Collections.emptyList();
    }

    public List<NodeTableStatistics> readNodeTable(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readAllNodeTable(node, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return Collections.emptyList();
    }

    public NodeTableStatistics nonCachedReadNodeTable(NodeTable table) {
        Node node = table.getNode();
        if (this.pluginReader != null && node != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readNodeTable(table, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public NodeTableStatistics readNodeTable(NodeTable table) {
        Node node = table.getNode();
        if (this.pluginReader != null && node != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readNodeTable(table, true);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return null;
    }

    public List<NodeConnectorStatistics> nonCachedReadNodeConnectors(Node node) {
        if (this.pluginReader != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).readAllNodeConnector(node, false);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return Collections.emptyList();
    }

    public long getTransmitRate(NodeConnector connector) {
        Node node = connector.getNode();
        if (this.pluginReader != null && node != null && this.pluginReader.get(node.getType()) != null) {
            return this.pluginReader.get(node.getType()).getTransmitRate(connector);
        }
        logger.warn("Plugin {} unavailable", (Object)node.getType());
        return 0L;
    }

    public void nodeFlowStatisticsUpdated(Node node, List<FlowOnNode> flowStatsList) {
        for (IReadServiceListener l : this.readerListeners) {
            l.nodeFlowStatisticsUpdated(node, flowStatsList);
        }
    }

    public void nodeConnectorStatisticsUpdated(Node node, List<NodeConnectorStatistics> ncStatsList) {
        for (IReadServiceListener l : this.readerListeners) {
            l.nodeConnectorStatisticsUpdated(node, ncStatsList);
        }
    }

    public void nodeTableStatisticsUpdated(Node node, List<NodeTableStatistics> tableStatsList) {
        for (IReadServiceListener l : this.readerListeners) {
            l.nodeTableStatisticsUpdated(node, tableStatsList);
        }
    }

    public void descriptionStatisticsUpdated(Node node, NodeDescription nodeDescription) {
        for (IReadServiceListener l : this.readerListeners) {
            l.descriptionStatisticsUpdated(node, nodeDescription);
        }
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---SAL Reader testing commands---\n");
        help.append("\t readflows <sid> <cached> - Read all the (cached) flows from the openflow switch <sid>\n");
        help.append("\t readflow  <sid> <cached> - Read the (cached) sample flow from the openflow switch <sid>\n");
        help.append("\t readdescr <sid> <cached> - Read the (cached) description from openflow switch <sid>\n");
        help.append("\t\t cached = (true|false). If false or not specified, the plugin cached info\n");
        help.append("\t\t is returned. If true, the info is directly retrieved from the switch\n");
        help.append("\t readport <sid> <port>    - Read port statistics for the specified port\n");
        help.append("\t readports <sid>          - Read port statistics for all ports of specified switch\n");
        help.append("\t readtable <sid> <tableid>- Read specified table statistics\n");
        return help.toString();
    }

    public void _readflows(CommandInterpreter ci) {
        List<FlowOnNode> list;
        String nodeId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        Node node = null;
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        List<FlowOnNode> list2 = list = cached ? this.readAllFlows(node) : this.nonCachedReadAllFlows(node);
        if (list != null) {
            ci.println((Object)list.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    public void _readflow(CommandInterpreter ci) throws UnknownHostException {
        FlowOnNode flowOnNode;
        String nodeId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        Node node = null;
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        Flow flow = this.getSampleFlow(node);
        FlowOnNode flowOnNode2 = flowOnNode = cached ? this.readFlow(node, flow) : this.nonCachedReadFlow(node, flow);
        if (flowOnNode != null) {
            ci.println((Object)flowOnNode.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    public void _readports(CommandInterpreter ci) {
        List<NodeConnectorStatistics> list;
        String nodeId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        Node node = null;
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        List<NodeConnectorStatistics> list2 = list = cached ? this.readNodeConnectors(node) : this.nonCachedReadNodeConnectors(node);
        if (list != null) {
            ci.println((Object)list.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    public void _readport(CommandInterpreter ci) {
        NodeConnectorStatistics stats;
        String nodeId = ci.nextArgument();
        String portId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        if (portId == null) {
            ci.print((Object)"Port id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        NodeConnector nodeConnector = null;
        Node node = NodeCreator.createOFNode((Long)Long.parseLong(nodeId));
        nodeConnector = NodeConnectorCreator.createNodeConnector((Object)Short.valueOf(portId), (Node)node);
        NodeConnectorStatistics nodeConnectorStatistics = stats = cached ? this.readNodeConnector(nodeConnector) : this.nonCachedReadNodeConnector(nodeConnector);
        if (stats != null) {
            ci.println((Object)stats.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    public void _readtable(CommandInterpreter ci) {
        NodeTableStatistics stats;
        String nodeId = ci.nextArgument();
        String tableId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        if (tableId == null) {
            ci.print((Object)"Table id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        NodeTable nodeTable = null;
        Node node = NodeCreator.createOFNode((Long)Long.parseLong(nodeId));
        nodeTable = NodeTableCreator.createNodeTable((byte)Byte.valueOf(tableId), (Node)node);
        NodeTableStatistics nodeTableStatistics = stats = cached ? this.readNodeTable(nodeTable) : this.nonCachedReadNodeTable(nodeTable);
        if (stats != null) {
            ci.println((Object)stats.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    public void _readdescr(CommandInterpreter ci) {
        NodeDescription desc;
        String nodeId = ci.nextArgument();
        String cacheReq = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        boolean cached = cacheReq == null ? true : cacheReq.equals("true");
        Node node = null;
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        NodeDescription nodeDescription = desc = cached ? this.readDescription(node) : this.nonCachedReadDescription(node);
        if (desc != null) {
            ci.println((Object)desc.toString());
        } else {
            ci.println((Object)"null");
        }
    }

    private Flow getSampleFlow(Node node) throws UnknownHostException {
        NodeConnector port = NodeConnectorCreator.createOFNodeConnector((Short)24, (Node)node);
        NodeConnector oport = NodeConnectorCreator.createOFNodeConnector((Short)30, (Node)node);
        byte[] srcMac = new byte[]{18, 52, 86, 120, -102, -68};
        byte[] dstMac = new byte[]{26, 43, 60, 77, 94, 111};
        InetAddress srcIP = InetAddress.getByName("172.28.30.50");
        InetAddress dstIP = InetAddress.getByName("171.71.9.52");
        InetAddress ipMask = InetAddress.getByName("255.255.255.0");
        InetAddress ipMask2 = InetAddress.getByName("255.0.0.0");
        short ethertype = EtherTypes.IPv4.shortValue();
        short vlan = 27;
        byte vlanPr = 3;
        Byte tos = 4;
        byte proto = IPProtocols.TCP.byteValue();
        short src = -10536;
        short dst = 80;
        Match match = new Match();
        match.setField(MatchType.IN_PORT, (Object)port);
        match.setField(MatchType.DL_SRC, (Object)srcMac);
        match.setField(MatchType.DL_DST, (Object)dstMac);
        match.setField(MatchType.DL_TYPE, (Object)ethertype);
        match.setField(MatchType.DL_VLAN, (Object)vlan);
        match.setField(MatchType.DL_VLAN_PR, (Object)vlanPr);
        match.setField(MatchType.NW_SRC, (Object)srcIP, (Object)ipMask);
        match.setField(MatchType.NW_DST, (Object)dstIP, (Object)ipMask2);
        match.setField(MatchType.NW_TOS, (Object)tos);
        match.setField(MatchType.NW_PROTO, (Object)proto);
        match.setField(MatchType.TP_SRC, (Object)src);
        match.setField(MatchType.TP_DST, (Object)dst);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new Output(oport));
        actions.add(new PopVlan());
        actions.add(new Flood());
        actions.add(new Controller());
        return new Flow(match, actions);
    }
}

