/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.implementation.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerListener;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerService;
import org.opendaylight.controller.sal.flowprogrammer.IPluginInFlowProgrammerService;
import org.opendaylight.controller.sal.flowprogrammer.IPluginOutFlowProgrammerService;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IPProtocols;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProgrammerService
implements IFlowProgrammerService,
IPluginOutFlowProgrammerService,
CommandProvider {
    protected static final Logger logger = LoggerFactory.getLogger(FlowProgrammerService.class);
    private ConcurrentHashMap<String, IPluginInFlowProgrammerService> pluginFlowProgrammer = new ConcurrentHashMap();
    private Set<IFlowProgrammerListener> listener = new HashSet<IFlowProgrammerListener>();
    private AtomicLong seq = new AtomicLong();

    public FlowProgrammerService() {
        this.seq.lazySet(1L);
    }

    void init() {
        logger.debug("INIT called!");
    }

    void destroy() {
        this.pluginFlowProgrammer.clear();
        logger.debug("DESTROY called!");
    }

    void start() {
        logger.debug("START called!");
        this.registerWithOSGIConsole();
    }

    void stop() {
        logger.debug("STOP called!");
    }

    public void setService(Map<String, Object> props, IPluginInFlowProgrammerService s) {
        if (this.pluginFlowProgrammer == null) {
            logger.error("pluginFlowProgrammer store null");
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Got a service set request {}", (Object)s);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                logger.trace("Prop key:({}) value:({})", (Object)entry.getKey(), entry.getValue());
            }
        }
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a pluginFlowProgrammer without any protocolPluginType provided");
        } else {
            this.pluginFlowProgrammer.put(type, s);
            logger.debug("Stored the pluginFlowProgrammer for type: {}", (Object)type);
        }
    }

    public void unsetService(Map<String, Object> props, IPluginInFlowProgrammerService s) {
        if (this.pluginFlowProgrammer == null) {
            logger.error("pluginFlowProgrammer store null");
            return;
        }
        logger.debug("Received unsetpluginFlowProgrammer request");
        if (logger.isTraceEnabled()) {
            logger.trace("Got a service set request {}", (Object)s);
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                logger.trace("Prop key:({}) value:({})", (Object)entry.getKey(), entry.getValue());
            }
        }
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a pluginFlowProgrammer without any protocolPluginType provided");
        } else if (this.pluginFlowProgrammer.get(type).equals(s)) {
            this.pluginFlowProgrammer.remove(type);
            logger.debug("Removed the pluginFlowProgrammer for type: {}", (Object)type);
        }
    }

    public void setListener(IFlowProgrammerListener s) {
        this.listener.add(s);
    }

    public void unsetListener(IFlowProgrammerListener s) {
        this.listener.remove(s);
    }

    public Status addFlow(Node node, Flow flow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).addFlow(node, flow);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status removeFlow(Node node, Flow flow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).removeFlow(node, flow);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status removeAllFlows(Node node) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).removeAllFlows(node);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status modifyFlow(Node node, Flow oldFlow, Flow newFlow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).modifyFlow(node, oldFlow, newFlow);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status addFlowAsync(Node node, Flow flow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).addFlowAsync(node, flow, this.getNextRid());
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status removeFlowAsync(Node node, Flow flow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).removeFlowAsync(node, flow, this.getNextRid());
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status modifyFlowAsync(Node node, Flow oldFlow, Flow newFlow) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).modifyFlowAsync(node, oldFlow, newFlow, this.getNextRid());
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public void flowRemoved(Node node, Flow flow) {
        for (IFlowProgrammerListener l : this.listener) {
            l.flowRemoved(node, flow);
        }
    }

    public void flowErrorReported(Node node, long rid, Object err) {
        logger.error("Got error {} for message rid {} from node {}", new Object[]{err, rid, node});
        for (IFlowProgrammerListener l : this.listener) {
            l.flowErrorReported(node, rid, err);
        }
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---SAL Flow Programmer testing commands---\n");
        help.append("\t addflow <sid> - Add a sample flow to the openflow switch <sid>\n");
        help.append("\t removeflow <sid> - Remove the sample flow from the openflow switch <sid>\n");
        return help.toString();
    }

    public void _addflow(CommandInterpreter ci) throws UnknownHostException {
        Node node = null;
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        ci.println((Object)this.addFlow(node, this.getSampleFlow(node)));
    }

    public void _modifyflow(CommandInterpreter ci) throws UnknownHostException {
        Node node = null;
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        Flow flowA = this.getSampleFlow(node);
        Flow flowB = this.getSampleFlow(node);
        Match matchB = flowB.getMatch();
        matchB.setField(MatchType.NW_DST, (Object)InetAddress.getByName("190.190.190.190"));
        flowB.setMatch(matchB);
        ci.println((Object)this.modifyFlow(node, flowA, flowB));
    }

    public void _removeflow(CommandInterpreter ci) throws UnknownHostException {
        Node node = null;
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        ci.println((Object)this.removeFlow(node, this.getSampleFlow(node)));
    }

    public void _addflowv6(CommandInterpreter ci) throws UnknownHostException {
        Node node = null;
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        ci.println((Object)this.addFlow(node, this.getSampleFlowV6(node)));
    }

    public void _removeflowv6(CommandInterpreter ci) throws UnknownHostException {
        Node node = null;
        String nodeId = ci.nextArgument();
        if (nodeId == null) {
            ci.print((Object)"Node id not specified");
            return;
        }
        try {
            node = new Node(Node.NodeIDType.OPENFLOW, (Object)Long.valueOf(nodeId));
        }
        catch (NumberFormatException e) {
            logger.error("", (Throwable)e);
        }
        catch (ConstructionException e) {
            logger.error("", (Throwable)e);
        }
        ci.println((Object)this.removeFlow(node, this.getSampleFlowV6(node)));
    }

    private Flow getSampleFlow(Node node) throws UnknownHostException {
        NodeConnector port = NodeConnectorCreator.createOFNodeConnector((Short)24, (Node)node);
        NodeConnector oport = NodeConnectorCreator.createOFNodeConnector((Short)30, (Node)node);
        byte[] srcMac = new byte[]{18, 52, 86, 120, -102, -68};
        byte[] dstMac = new byte[]{26, 43, 60, 77, 94, 111};
        InetAddress srcIP = InetAddress.getByName("172.28.30.50");
        InetAddress dstIP = InetAddress.getByName("171.71.9.52");
        InetAddress newIP = InetAddress.getByName("200.200.100.1");
        InetAddress ipMask = InetAddress.getByName("255.255.255.0");
        InetAddress ipMask2 = InetAddress.getByName("255.240.0.0");
        short ethertype = EtherTypes.IPv4.shortValue();
        short vlan = 27;
        byte vlanPr = 3;
        Byte tos = 4;
        byte proto = IPProtocols.TCP.byteValue();
        short src = -10536;
        short dst = 80;
        Match match = new Match();
        match.setField(MatchType.IN_PORT, (Object)port);
        match.setField(MatchType.DL_SRC, (Object)srcMac);
        match.setField(MatchType.DL_DST, (Object)dstMac);
        match.setField(MatchType.DL_TYPE, (Object)ethertype);
        match.setField(MatchType.DL_VLAN, (Object)vlan);
        match.setField(MatchType.DL_VLAN_PR, (Object)vlanPr);
        match.setField(MatchType.NW_SRC, (Object)srcIP, (Object)ipMask);
        match.setField(MatchType.NW_DST, (Object)dstIP, (Object)ipMask2);
        match.setField(MatchType.NW_TOS, (Object)tos);
        match.setField(MatchType.NW_PROTO, (Object)proto);
        match.setField(MatchType.TP_SRC, (Object)src);
        match.setField(MatchType.TP_DST, (Object)dst);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new SetNwDst(newIP));
        actions.add(new Output(oport));
        actions.add(new PopVlan());
        actions.add(new Flood());
        actions.add(new Controller());
        Flow flow = new Flow(match, actions);
        flow.setPriority((short)100);
        flow.setHardTimeout((short)360);
        flow.setId(1234L);
        return flow;
    }

    private Flow getSampleFlowV6(Node node) throws UnknownHostException {
        NodeConnector port = NodeConnectorCreator.createOFNodeConnector((Short)24, (Node)node);
        NodeConnector oport = NodeConnectorCreator.createOFNodeConnector((Short)30, (Node)node);
        byte[] srcMac = new byte[]{18, 52, 86, 120, -102, -68};
        byte[] dstMac = new byte[]{26, 43, 60, 77, 94, 111};
        InetAddress srcIP = InetAddress.getByName("2001:420:281:1004:407a:57f4:4d15:c355");
        InetAddress dstIP = InetAddress.getByName("2001:420:281:1004:e123:e688:d655:a1b0");
        Object ipMask = null;
        Object ipMask2 = null;
        short ethertype = EtherTypes.IPv6.shortValue();
        short vlan = 27;
        byte vlanPr = 3;
        Byte tos = 4;
        byte proto = IPProtocols.UDP.byteValue();
        short src = 5500;
        Match match = new Match();
        match.setField(MatchType.IN_PORT, (Object)port);
        match.setField(MatchType.DL_SRC, (Object)srcMac);
        match.setField(MatchType.DL_DST, (Object)dstMac);
        match.setField(MatchType.DL_TYPE, (Object)ethertype);
        match.setField(MatchType.DL_VLAN, (Object)vlan);
        match.setField(MatchType.DL_VLAN_PR, (Object)vlanPr);
        match.setField(MatchType.NW_SRC, (Object)srcIP, ipMask);
        match.setField(MatchType.NW_DST, (Object)dstIP, ipMask2);
        match.setField(MatchType.NW_TOS, (Object)tos);
        match.setField(MatchType.NW_PROTO, (Object)proto);
        match.setField(MatchType.TP_SRC, (Object)src);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(new Output(oport));
        actions.add(new PopVlan());
        actions.add(new Flood());
        Flow flow = new Flow(match, actions);
        flow.setPriority((short)300);
        flow.setHardTimeout((short)240);
        flow.setId(65536L);
        return flow;
    }

    private long getNextRid() {
        return this.seq.getAndIncrement();
    }

    public Status syncSendBarrierMessage(Node node) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).syncSendBarrierMessage(node);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }

    public Status asyncSendBarrierMessage(Node node) {
        if (this.pluginFlowProgrammer != null && this.pluginFlowProgrammer.get(node.getType()) != null) {
            return this.pluginFlowProgrammer.get(node.getType()).asyncSendBarrierMessage(node);
        }
        return new Status(StatusCode.NOSERVICE, "Plugin unuvailable");
    }
}

