/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.networkconfig.bridgedomain.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.ConfigConstants;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.IBridgeDomainConfigService;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.IPluginInBridgeDomainConfigService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeDomainConfigService
implements IBridgeDomainConfigService {
    protected static final Logger logger = LoggerFactory.getLogger(BridgeDomainConfigService.class);
    private ConcurrentMap<String, IPluginInBridgeDomainConfigService> pluginService = new ConcurrentHashMap<String, IPluginInBridgeDomainConfigService>();

    void setPluginInService(Map props, IPluginInBridgeDomainConfigService s) {
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a PluginInConnectionService without any protocolPluginType provided");
        } else {
            this.pluginService.put(type, s);
        }
    }

    void unsetPluginInService(Map props, IPluginInBridgeDomainConfigService s) {
        String type = null;
        Object value = props.get(GlobalConstants.PROTOCOLPLUGINTYPE.toString());
        if (value instanceof String) {
            type = (String)value;
        }
        if (type == null) {
            logger.error("Received a PluginInConnectionService without any protocolPluginType provided");
        } else if (((IPluginInBridgeDomainConfigService)this.pluginService.get(type)).equals(s)) {
            this.pluginService.remove(type);
        }
    }

    void init() {
    }

    void destroy() {
        if (this.pluginService != null) {
            this.pluginService.clear();
        }
    }

    public Status createBridgeDomain(Node node, String bridgeIdentifier, Map<ConfigConstants, Object> params) throws Throwable {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.createBridgeDomain(node, bridgeIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Status deleteBridgeDomain(Node node, String bridgeIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.deleteBridgeDomain(node, bridgeIdentifier);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public List<String> getBridgeDomains(Node node) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.getBridgeDomains(node);
        }
        return null;
    }

    public Status addBridgeDomainConfig(Node node, String bridgeIdentifier, Map<ConfigConstants, Object> params) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.addBridgeDomainConfig(node, bridgeIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Status removeBridgeDomainConfig(Node node, String bridgeIdentifier, Map<ConfigConstants, Object> params) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.removeBridgeDomainConfig(node, bridgeIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Map<ConfigConstants, Object> getBridgeDomainConfigs(Node node, String bridgeIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.getBridgeDomainConfigs(node, bridgeIdentifier);
        }
        return null;
    }

    public Node getBridgeDomainNode(Node configNode, String bridgeIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(configNode.getType())) != null) {
            return plugin.getBridgeDomainNode(configNode, bridgeIdentifier);
        }
        return null;
    }

    public Status addPort(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> params) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.addPort(node, bridgeIdentifier, portIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Status deletePort(Node node, String bridgeIdentifier, String portIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.deletePort(node, bridgeIdentifier, portIdentifier);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Status addPortConfig(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> params) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.addPortConfig(node, bridgeIdentifier, portIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Status removePortConfig(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> params) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.removePortConfig(node, bridgeIdentifier, portIdentifier, params);
        }
        return new Status(StatusCode.NOSERVICE, "Requested Plugin Service Not available");
    }

    public Map<ConfigConstants, Object> getPortConfigs(Node node, String bridgeIdentifier, String portIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(node.getType())) != null) {
            return plugin.getPortConfigs(node, bridgeIdentifier, portIdentifier);
        }
        return null;
    }

    public NodeConnector getNodeConnector(Node configNode, String bridgeIdentifier, String portIdentifier) {
        IPluginInBridgeDomainConfigService plugin;
        if (this.pluginService != null && (plugin = (IPluginInBridgeDomainConfigService)this.pluginService.get(configNode.getType())) != null) {
            return plugin.getNodeConnector(configNode, bridgeIdentifier, portIdentifier);
        }
        return null;
    }
}

